/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.xml.transform.dom.DOMSource;
import org.checkerframework.checker.regex.qual.Regex;
import org.opendaylight.yangtools.concepts.ObjectExtensions;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointContext;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointIdentifier;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointStreamWriter;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedAnydata;
import org.opendaylight.yangtools.yang.data.api.schema.stream.AnydataExtension;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriterExtension;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterContext;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterExclusiveRootContext;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterInvisibleContext;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterListContext;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterNamedObjectContext;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterObjectContext;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterRootContext;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterSharedRootContext;
import org.opendaylight.yangtools.yang.data.impl.codec.SchemaTracker;
import org.opendaylight.yangtools.yang.data.util.SingleChildDataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.AnyDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class JSONNormalizedNodeStreamWriter
implements NormalizedNodeStreamWriter,
AnydataExtension,
MountPointStreamWriter {
    private static final boolean DEFAULT_EMIT_EMPTY_CONTAINERS = true;
    static final ObjectExtensions.Factory<JSONNormalizedNodeStreamWriter, NormalizedNodeStreamWriter, NormalizedNodeStreamWriterExtension> EXTENSIONS_BUILDER = ObjectExtensions.factory(JSONNormalizedNodeStreamWriter.class, (Class[])new Class[]{AnydataExtension.class, MountPointStreamWriter.class});
    private static final @Regex String NUMBER_STRING = "-?\\d+(\\.\\d+)?";
    private static final Pattern NUMBER_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?");
    private static final @Regex String NOT_DECIMAL_NUMBER_STRING = "-?\\d+";
    private static final Pattern NOT_DECIMAL_NUMBER_PATTERN = Pattern.compile("-?\\d+");
    private final SchemaTracker tracker;
    private final JSONCodecFactory codecs;
    private final JsonWriter writer;
    private JSONStreamWriterContext context;

    JSONNormalizedNodeStreamWriter(JSONCodecFactory codecFactory, SchemaTracker tracker, JsonWriter writer, JSONStreamWriterRootContext rootContext) {
        this.writer = Objects.requireNonNull(writer);
        this.codecs = Objects.requireNonNull(codecFactory);
        this.tracker = Objects.requireNonNull(tracker);
        this.context = Objects.requireNonNull(rootContext);
    }

    public static NormalizedNodeStreamWriter createExclusiveWriter(JSONCodecFactory codecFactory, SchemaPath path, URI initialNs, JsonWriter jsonWriter) {
        return new Exclusive(codecFactory, SchemaTracker.create((SchemaContext)codecFactory.getSchemaContext(), (SchemaPath)path), jsonWriter, new JSONStreamWriterExclusiveRootContext(initialNs));
    }

    public static NormalizedNodeStreamWriter createExclusiveWriter(JSONCodecFactory codecFactory, DataNodeContainer rootNode, URI initialNs, JsonWriter jsonWriter) {
        return new Exclusive(codecFactory, SchemaTracker.create((DataNodeContainer)rootNode), jsonWriter, new JSONStreamWriterExclusiveRootContext(initialNs));
    }

    public static NormalizedNodeStreamWriter createNestedWriter(JSONCodecFactory codecFactory, SchemaPath path, URI initialNs, JsonWriter jsonWriter) {
        return new Nested(codecFactory, SchemaTracker.create((SchemaContext)codecFactory.getSchemaContext(), (SchemaPath)path), jsonWriter, new JSONStreamWriterSharedRootContext(initialNs));
    }

    public static NormalizedNodeStreamWriter createNestedWriter(JSONCodecFactory codecFactory, DataNodeContainer rootNode, URI initialNs, JsonWriter jsonWriter) {
        return new Nested(codecFactory, SchemaTracker.create((DataNodeContainer)rootNode), jsonWriter, new JSONStreamWriterSharedRootContext(initialNs));
    }

    public ClassToInstanceMap<NormalizedNodeStreamWriterExtension> getExtensions() {
        return EXTENSIONS_BUILDER.newInstance((Object)this);
    }

    public void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        this.tracker.startLeafNode(name);
        this.context.emittingChild(this.codecs.getSchemaContext(), this.writer);
        this.context.writeChildJsonIdentifier(this.codecs.getSchemaContext(), this.writer, name.getNodeType());
    }

    public final void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.tracker.startLeafSet(name);
        this.context = new JSONStreamWriterListContext(this.context, name);
    }

    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) throws IOException {
        this.tracker.startLeafSetEntryNode(name);
        this.context.emittingChild(this.codecs.getSchemaContext(), this.writer);
    }

    public final void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.tracker.startLeafSet(name);
        this.context = new JSONStreamWriterListContext(this.context, name);
    }

    public final void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        SchemaNode schema = this.tracker.startContainerNode(name);
        boolean isPresence = schema instanceof ContainerSchemaNode ? ((ContainerSchemaNode)schema).isPresenceContainer() : true;
        this.context = new JSONStreamWriterNamedObjectContext(this.context, (YangInstanceIdentifier.PathArgument)name, isPresence);
    }

    public final void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.tracker.startList((YangInstanceIdentifier.PathArgument)name);
        this.context = new JSONStreamWriterListContext(this.context, name);
    }

    public final void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.tracker.startListItem((YangInstanceIdentifier.PathArgument)name);
        this.context = new JSONStreamWriterObjectContext(this.context, (YangInstanceIdentifier.PathArgument)name, true);
    }

    public final void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.tracker.startList((YangInstanceIdentifier.PathArgument)name);
        this.context = new JSONStreamWriterListContext(this.context, name);
    }

    public final void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) throws IOException {
        this.tracker.startListItem((YangInstanceIdentifier.PathArgument)identifier);
        this.context = new JSONStreamWriterObjectContext(this.context, (YangInstanceIdentifier.PathArgument)identifier, true);
    }

    public final void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.tracker.startList((YangInstanceIdentifier.PathArgument)name);
        this.context = new JSONStreamWriterListContext(this.context, name);
    }

    public final void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.tracker.startChoiceNode(name);
        this.context = new JSONStreamWriterInvisibleContext(this.context);
    }

    public final void startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier identifier) {
        this.tracker.startAugmentationNode(identifier);
        this.context = new JSONStreamWriterInvisibleContext(this.context);
    }

    public final boolean startAnydataNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) throws IOException {
        if (NormalizedAnydata.class.isAssignableFrom(objectModel)) {
            this.tracker.startAnydataNode(name);
            this.context.emittingChild(this.codecs.getSchemaContext(), this.writer);
            this.context.writeChildJsonIdentifier(this.codecs.getSchemaContext(), this.writer, name.getNodeType());
            return true;
        }
        return false;
    }

    public final NormalizedNodeStreamWriter startMountPoint(MountPointIdentifier mountId, MountPointContext mountCtx) throws IOException {
        SchemaContext ctx = mountCtx.getSchemaContext();
        return new Nested(this.codecs.rebaseTo(ctx), SchemaTracker.create((DataNodeContainer)ctx), this.writer, new JSONStreamWriterSharedRootContext(this.context.getNamespace()));
    }

    public final void startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        this.tracker.startAnyxmlNode(name);
        this.context.emittingChild(this.codecs.getSchemaContext(), this.writer);
        this.context.writeChildJsonIdentifier(this.codecs.getSchemaContext(), this.writer, name.getNodeType());
    }

    public final void startYangModeledAnyXmlNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.tracker.startYangModeledAnyXmlNode(name);
        this.context = new JSONStreamWriterNamedObjectContext(this.context, (YangInstanceIdentifier.PathArgument)name, true);
    }

    public final void endNode() throws IOException {
        this.tracker.endNode();
        this.context = this.context.endNode(this.codecs.getSchemaContext(), this.writer);
    }

    public final void flush() throws IOException {
        this.writer.flush();
    }

    final void closeWriter() throws IOException {
        if (!(this.context instanceof JSONStreamWriterRootContext)) {
            throw new IOException("Unexpected root context " + this.context);
        }
        this.context.endNode(this.codecs.getSchemaContext(), this.writer);
        this.writer.close();
    }

    public void scalarValue(Object value) throws IOException {
        Object current = this.tracker.getParent();
        if (current instanceof TypedDataSchemaNode) {
            this.writeValue(value, (JSONCodec)this.codecs.codecFor((TypeAware)((TypedDataSchemaNode)current)));
        } else if (current instanceof AnyDataSchemaNode) {
            this.writeAnydataValue(value);
        } else {
            throw new IllegalStateException(String.format("Cannot emit scalar %s for %s", value, current));
        }
    }

    public void domSourceValue(DOMSource value) throws IOException {
        Object current = this.tracker.getParent();
        Preconditions.checkState((boolean)(current instanceof AnyXmlSchemaNode), (String)"Cannot emit DOMSource %s for %s", (Object)value, (Object)current);
        this.writeAnyXmlValue(value);
    }

    private void writeValue(Object value, JSONCodec<?> codec) throws IOException {
        codec.writeValue(this.writer, value);
    }

    private void writeAnydataValue(Object value) throws IOException {
        if (!(value instanceof NormalizedAnydata)) {
            throw new IllegalStateException("Unexpected anydata value " + value);
        }
        this.writeNormalizedAnydata((NormalizedAnydata)value);
    }

    private void writeNormalizedAnydata(NormalizedAnydata anydata) throws IOException {
        anydata.writeTo(JSONNormalizedNodeStreamWriter.createNestedWriter(this.codecs.rebaseTo(anydata.getSchemaContext()), (DataNodeContainer)new SingleChildDataNodeContainer(anydata.getContextNode()), this.context.getNamespace(), this.writer));
    }

    private void writeAnyXmlValue(DOMSource anyXmlValue) throws IOException {
        this.writeXmlNode(anyXmlValue.getNode());
    }

    private void writeXmlNode(Node node) throws IOException {
        if (JSONNormalizedNodeStreamWriter.isArrayElement(node)) {
            this.writeArrayContent(node);
            return;
        }
        Element firstChildElement = JSONNormalizedNodeStreamWriter.getFirstChildElement(node);
        if (firstChildElement == null) {
            this.writeXmlValue(node);
        } else {
            this.writeObjectContent(firstChildElement);
        }
    }

    private void writeArrayContent(Node node) throws IOException {
        this.writer.beginArray();
        this.handleArray(node);
        this.writer.endArray();
    }

    private void writeObjectContent(Element firstChildElement) throws IOException {
        this.writer.beginObject();
        this.writeObject(firstChildElement);
        this.writer.endObject();
    }

    private static boolean isArrayElement(Node node) {
        if (1 == node.getNodeType()) {
            String nodeName = node.getNodeName();
            for (Node nextNode = node.getNextSibling(); nextNode != null; nextNode = nextNode.getNextSibling()) {
                if (1 != nextNode.getNodeType() || !nodeName.equals(nextNode.getNodeName())) continue;
                return true;
            }
        }
        return false;
    }

    private void handleArray(Node node) throws IOException {
        Element parentNode = (Element)node.getParentNode();
        NodeList elementsList = parentNode.getElementsByTagName(node.getNodeName());
        int length = elementsList.getLength();
        for (int i = 0; i < length; ++i) {
            Node arrayElement = elementsList.item(i);
            Element parent = (Element)arrayElement.getParentNode();
            if (!parentNode.isSameNode(parent)) continue;
            Element firstChildElement = JSONNormalizedNodeStreamWriter.getFirstChildElement(arrayElement);
            if (firstChildElement != null) {
                this.writeObjectContent(firstChildElement);
                continue;
            }
            this.writeXmlValue(arrayElement);
        }
    }

    private void writeObject(Node node) throws IOException {
        String previousNodeName = "";
        while (node != null) {
            if (1 == node.getNodeType() && !node.getNodeName().equals(previousNodeName)) {
                previousNodeName = node.getNodeName();
                this.writer.name(node.getNodeName());
                this.writeXmlNode(node);
            }
            node = node.getNextSibling();
        }
    }

    private void writeXmlValue(Node node) throws IOException {
        Text firstChild = JSONNormalizedNodeStreamWriter.getFirstChildText(node);
        String childNodeText = firstChild != null ? firstChild.getWholeText() : "";
        String string = childNodeText = childNodeText != null ? childNodeText.trim() : "";
        if (NUMBER_PATTERN.matcher(childNodeText).matches()) {
            this.writer.value(JSONNormalizedNodeStreamWriter.parseNumber(childNodeText));
            return;
        }
        switch (childNodeText) {
            case "null": {
                this.writer.nullValue();
                break;
            }
            case "false": {
                this.writer.value(false);
                break;
            }
            case "true": {
                this.writer.value(true);
                break;
            }
            default: {
                this.writer.value(childNodeText);
            }
        }
    }

    private static Element getFirstChildElement(Node node) {
        NodeList children = node.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node childNode = children.item(i);
            if (1 != childNode.getNodeType()) continue;
            return (Element)childNode;
        }
        return null;
    }

    private static Text getFirstChildText(Node node) {
        NodeList children = node.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node childNode = children.item(i);
            if (3 != childNode.getNodeType()) continue;
            return (Text)childNode;
        }
        return null;
    }

    private static Number parseNumber(String numberText) {
        if (NOT_DECIMAL_NUMBER_PATTERN.matcher(numberText).matches()) {
            return Long.valueOf(numberText);
        }
        return Double.valueOf(numberText);
    }

    private static final class Nested
    extends JSONNormalizedNodeStreamWriter {
        Nested(JSONCodecFactory codecFactory, SchemaTracker tracker, JsonWriter writer, JSONStreamWriterRootContext rootContext) {
            super(codecFactory, tracker, writer, rootContext);
        }

        public void close() throws IOException {
            this.flush();
        }
    }

    private static final class Exclusive
    extends JSONNormalizedNodeStreamWriter {
        Exclusive(JSONCodecFactory codecFactory, SchemaTracker tracker, JsonWriter writer, JSONStreamWriterRootContext rootContext) {
            super(codecFactory, tracker, writer, rootContext);
        }

        public void close() throws IOException {
            this.flush();
            this.closeWriter();
        }
    }
}

