/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.annotations.Beta;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.codec.gson.BooleanJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.EmptyJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.IdentityrefJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.NullJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.NumberJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.QuotedJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.UnionJSONCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.AbstractIntegerStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BinaryStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BitsStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BooleanStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.DataStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.DecimalStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.EnumStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.StringStringCodec;
import org.opendaylight.yangtools.yang.data.util.codec.AbstractCodecFactory;
import org.opendaylight.yangtools.yang.data.util.codec.CodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.LazyCodecCache;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnknownTypeDefinition;

@Beta
public abstract class JSONCodecFactory
extends AbstractCodecFactory<JSONCodec<?>> {
    JSONCodecFactory(@NonNull EffectiveModelContext context, @NonNull CodecCache<JSONCodec<?>> cache) {
        super(context, cache);
    }

    protected final JSONCodec<?> binaryCodec(BinaryTypeDefinition type) {
        return new QuotedJSONCodec(BinaryStringCodec.from((BinaryTypeDefinition)type));
    }

    protected final JSONCodec<?> booleanCodec(BooleanTypeDefinition type) {
        return new BooleanJSONCodec((DataStringCodec<Boolean>)BooleanStringCodec.from((BooleanTypeDefinition)type));
    }

    protected final JSONCodec<?> bitsCodec(BitsTypeDefinition type) {
        return new QuotedJSONCodec(BitsStringCodec.from((BitsTypeDefinition)type));
    }

    protected final JSONCodec<?> decimalCodec(DecimalTypeDefinition type) {
        return this.wrapDecimalCodec(DecimalStringCodec.from((DecimalTypeDefinition)type));
    }

    protected final JSONCodec<?> emptyCodec(EmptyTypeDefinition type) {
        return EmptyJSONCodec.INSTANCE;
    }

    protected final JSONCodec<?> enumCodec(EnumTypeDefinition type) {
        return new QuotedJSONCodec(EnumStringCodec.from((EnumTypeDefinition)type));
    }

    protected final JSONCodec<?> identityRefCodec(IdentityrefTypeDefinition type, QNameModule module) {
        return new IdentityrefJSONCodec(this.getEffectiveModelContext(), module);
    }

    protected final JSONCodec<?> int8Codec(Int8TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Int8TypeDefinition)type));
    }

    protected final JSONCodec<?> int16Codec(Int16TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Int16TypeDefinition)type));
    }

    protected final JSONCodec<?> int32Codec(Int32TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Int32TypeDefinition)type));
    }

    protected final JSONCodec<?> int64Codec(Int64TypeDefinition type) {
        return this.wrapIntegerCodec(AbstractIntegerStringCodec.from((Int64TypeDefinition)type));
    }

    protected final JSONCodec<?> stringCodec(StringTypeDefinition type) {
        return new QuotedJSONCodec(StringStringCodec.from((StringTypeDefinition)type));
    }

    protected final JSONCodec<?> uint8Codec(Uint8TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Uint8TypeDefinition)type));
    }

    protected final JSONCodec<?> uint16Codec(Uint16TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Uint16TypeDefinition)type));
    }

    protected final JSONCodec<?> uint32Codec(Uint32TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Uint32TypeDefinition)type));
    }

    protected final JSONCodec<?> uint64Codec(Uint64TypeDefinition type) {
        return this.wrapIntegerCodec(AbstractIntegerStringCodec.from((Uint64TypeDefinition)type));
    }

    protected final JSONCodec<?> unionCodec(UnionTypeDefinition type, List<JSONCodec<?>> codecs) {
        return UnionJSONCodec.create(type, codecs);
    }

    protected final JSONCodec<?> unknownCodec(UnknownTypeDefinition type) {
        return NullJSONCodec.INSTANCE;
    }

    protected abstract JSONCodec<?> instanceIdentifierCodec(InstanceIdentifierTypeDefinition var1);

    final JSONCodecFactory rebaseTo(EffectiveModelContext newSchemaContext) {
        return this.rebaseTo(newSchemaContext, (CodecCache<JSONCodec<?>>)new LazyCodecCache());
    }

    abstract JSONCodecFactory rebaseTo(EffectiveModelContext var1, CodecCache<JSONCodec<?>> var2);

    abstract JSONCodec<?> wrapDecimalCodec(DecimalStringCodec var1);

    abstract JSONCodec<?> wrapIntegerCodec(AbstractIntegerStringCodec<?, ?> var1);
}

