/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.QuotedJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.RFC7951JSONInstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.AbstractIntegerStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.DecimalStringCodec;
import org.opendaylight.yangtools.yang.data.util.codec.CodecCache;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;

final class RFC7951JSONCodecFactory
extends JSONCodecFactory {
    private final RFC7951JSONInstanceIdentifierCodec iidCodec;

    RFC7951JSONCodecFactory(EffectiveModelContext context, CodecCache<JSONCodec<?>> cache) {
        super(context, cache);
        this.iidCodec = new RFC7951JSONInstanceIdentifierCodec(context, this);
    }

    @Override
    protected JSONCodec<?> instanceIdentifierCodec(InstanceIdentifierTypeDefinition type) {
        return this.iidCodec;
    }

    @Override
    JSONCodecFactory rebaseTo(EffectiveModelContext newSchemaContext, CodecCache<JSONCodec<?>> newCache) {
        return new RFC7951JSONCodecFactory(newSchemaContext, newCache);
    }

    @Override
    JSONCodec<?> wrapDecimalCodec(DecimalStringCodec decimalCodec) {
        return new QuotedJSONCodec(decimalCodec);
    }

    @Override
    JSONCodec<?> wrapIntegerCodec(AbstractIntegerStringCodec<?, ?> integerCodec) {
        return new QuotedJSONCodec(integerCodec);
    }
}

