/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.AbstractImmutableDataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.valid.DataValidationException;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.AbstractImmutableDataContainerNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableMapEntryNodeBuilder
extends AbstractImmutableDataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> {
    private static final Logger LOG = LoggerFactory.getLogger(ImmutableMapEntryNodeBuilder.class);
    protected final Map<QName, YangInstanceIdentifier.PathArgument> childrenQNamesToPaths;

    protected ImmutableMapEntryNodeBuilder() {
        this.childrenQNamesToPaths = new LinkedHashMap<QName, YangInstanceIdentifier.PathArgument>();
    }

    protected ImmutableMapEntryNodeBuilder(int sizeHint) {
        super(sizeHint);
        this.childrenQNamesToPaths = new LinkedHashMap<QName, YangInstanceIdentifier.PathArgument>(sizeHint);
    }

    protected ImmutableMapEntryNodeBuilder(ImmutableMapEntryNode node) {
        super(node);
        this.childrenQNamesToPaths = new LinkedHashMap<QName, YangInstanceIdentifier.PathArgument>();
        ImmutableMapEntryNodeBuilder.fillQNames((Iterable<DataContainerChild>)node.body(), this.childrenQNamesToPaths);
    }

    public static @NonNull DataContainerNodeBuilder<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> create() {
        return new ImmutableMapEntryNodeBuilder();
    }

    public static @NonNull DataContainerNodeBuilder<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> create(int sizeHint) {
        return new ImmutableMapEntryNodeBuilder(sizeHint);
    }

    public static @NonNull DataContainerNodeBuilder<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> create(MapEntryNode node) {
        if (!(node instanceof ImmutableMapEntryNode)) {
            throw new UnsupportedOperationException("Cannot initialize from class " + node.getClass());
        }
        return new ImmutableMapEntryNodeBuilder((ImmutableMapEntryNode)node);
    }

    private static void fillQNames(Iterable<DataContainerChild> iterable, Map<QName, YangInstanceIdentifier.PathArgument> out) {
        for (DataContainerChild child : iterable) {
            ImmutableMapEntryNodeBuilder.putQName(out, child);
        }
    }

    private static void putQName(Map<QName, YangInstanceIdentifier.PathArgument> map, DataContainerChild child) {
        YangInstanceIdentifier.PathArgument identifier = child.getIdentifier();
        if (!(identifier instanceof YangInstanceIdentifier.AugmentationIdentifier)) {
            map.put(identifier.getNodeType(), identifier);
        }
    }

    @Override
    public DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> withValue(Collection<DataContainerChild> withValue) {
        ImmutableMapEntryNodeBuilder.fillQNames(withValue, this.childrenQNamesToPaths);
        return super.withValue(withValue);
    }

    @Override
    public DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> withChild(DataContainerChild child) {
        ImmutableMapEntryNodeBuilder.putQName(this.childrenQNamesToPaths, child);
        return super.withChild(child);
    }

    public MapEntryNode build() {
        for (Map.Entry key : ((YangInstanceIdentifier.NodeIdentifierWithPredicates)this.getNodeIdentifier()).entrySet()) {
            DataContainerChild childNode = this.getChild(this.childrenQNamesToPaths.get(key.getKey()));
            if (childNode == null) {
                LeafNode leaf = ImmutableNodes.leafNode((QName)key.getKey(), key.getValue());
                LOG.debug("Adding leaf {} implied by key {}", leaf, (Object)key);
                this.withChild((DataContainerChild)leaf);
                continue;
            }
            DataValidationException.checkListKey((YangInstanceIdentifier.NodeIdentifierWithPredicates)this.getNodeIdentifier(), (QName)key.getKey(), key.getValue(), childNode.body());
        }
        return new ImmutableMapEntryNode((YangInstanceIdentifier.NodeIdentifierWithPredicates)this.getNodeIdentifier(), this.buildValue());
    }

    private static final class ImmutableMapEntryNode
    extends AbstractImmutableDataContainerNode<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>
    implements MapEntryNode {
        ImmutableMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates nodeIdentifier, Map<YangInstanceIdentifier.PathArgument, Object> children) {
            super(children, nodeIdentifier);
        }

        protected Class<MapEntryNode> implementedType() {
            return MapEntryNode.class;
        }
    }
}

