/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.Optional;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.SystemLeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.builder.NormalizedNodeBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.builder.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableMetadataNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizationResultBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizationResultHolder;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.spi.node.InterningLeafNodeBuilder;
import org.opendaylight.yangtools.yang.data.spi.node.InterningLeafSetNodeBuilder;
import org.opendaylight.yangtools.yang.data.util.LeafInterner;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;

public class ImmutableNormalizedNodeStreamWriter
implements NormalizedNodeStreamWriter {
    private static final Interner<LeafSetEntryNode<?>> ENTRY_INTERNER = Interners.newWeakInterner();
    private static final NormalizedNode.BuilderFactory BUILDER_FACTORY = ImmutableNodes.builderFactory();
    private final Deque<NormalizedNode.Builder> builders = new ArrayDeque<NormalizedNode.Builder>();
    private DataSchemaNode nextSchema;

    protected ImmutableNormalizedNodeStreamWriter(NormalizedNode.Builder topLevelBuilder) {
        this.builders.push(topLevelBuilder);
    }

    protected ImmutableNormalizedNodeStreamWriter(NormalizationResultHolder holder) {
        this((NormalizedNode.Builder)new NormalizationResultBuilder(holder));
    }

    public static @NonNull NormalizedNodeStreamWriter from(NormalizedNodeContainerBuilder<?, ?, ?, ?> builder) {
        return new ImmutableNormalizedNodeStreamWriter((NormalizedNode.Builder)builder);
    }

    public static @NonNull NormalizedNodeStreamWriter from(NormalizationResultHolder holder) {
        return new ImmutableMetadataNormalizedNodeStreamWriter(holder);
    }

    public void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)this.leafNodeBuilder(this.nextSchema));
        this.nextSchema = null;
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        SystemLeafSetNode.Builder builder = -1 == childSizeHint ? BUILDER_FACTORY.newSystemLeafSetBuilder() : BUILDER_FACTORY.newSystemLeafSetBuilder(childSizeHint);
        this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)ImmutableNormalizedNodeStreamWriter.leafSetNodeBuilder(builder, this.nextSchema));
    }

    private static <T> SystemLeafSetNode.Builder<T> leafSetNodeBuilder(SystemLeafSetNode.Builder<T> delegate, @Nullable DataSchemaNode schema) {
        LeafListSchemaNode leafListSchema;
        TypeDefinition type;
        if (schema instanceof LeafListSchemaNode && ((type = (leafListSchema = (LeafListSchemaNode)schema).getType()) instanceof BooleanTypeDefinition || type instanceof EnumTypeDefinition || type instanceof IdentityrefTypeDefinition)) {
            return new InterningLeafSetNodeBuilder(delegate, ENTRY_INTERNER);
        }
        return delegate;
    }

    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) {
        NormalizedNode.Builder current = this.current();
        Preconditions.checkArgument((current instanceof LeafSetNode.Builder || current instanceof NormalizationResultBuilder ? 1 : 0) != 0, (String)"LeafSetEntryNode is not valid for parent %s", (Object)current);
        this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)this.leafsetEntryNodeBuilder());
        this.nextSchema = null;
    }

    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)(-1 == childSizeHint ? BUILDER_FACTORY.newUserLeafSetBuilder() : BUILDER_FACTORY.newUserLeafSetBuilder(childSizeHint)));
    }

    public boolean startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) {
        this.checkDataNodeContainer();
        if (DOMSource.class.isAssignableFrom(objectModel)) {
            this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)BUILDER_FACTORY.newAnyxmlBuilder(DOMSource.class));
            this.nextSchema = null;
            return true;
        }
        return false;
    }

    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)(-1 == childSizeHint ? BUILDER_FACTORY.newContainerBuilder() : BUILDER_FACTORY.newContainerBuilder(childSizeHint)));
    }

    public void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)(-1 == childSizeHint ? BUILDER_FACTORY.newUnkeyedListBuilder() : BUILDER_FACTORY.newUnkeyedListBuilder(childSizeHint)));
    }

    public void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        NormalizedNode.Builder current = this.current();
        Preconditions.checkArgument((current instanceof UnkeyedListNode.Builder || current instanceof NormalizationResultBuilder ? 1 : 0) != 0);
        this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)(-1 == childSizeHint ? BUILDER_FACTORY.newUnkeyedListEntryBuilder() : BUILDER_FACTORY.newUnkeyedListEntryBuilder(childSizeHint)));
    }

    public void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)(-1 == childSizeHint ? BUILDER_FACTORY.newSystemMapBuilder() : BUILDER_FACTORY.newSystemMapBuilder(childSizeHint)));
    }

    public void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) {
        NormalizedNode.Builder current = this.current();
        Preconditions.checkArgument((current instanceof MapNode.Builder || current instanceof NormalizationResultBuilder ? 1 : 0) != 0);
        this.enter((YangInstanceIdentifier.PathArgument)identifier, (NormalizedNodeBuilder)(-1 == childSizeHint ? BUILDER_FACTORY.newMapEntryBuilder() : BUILDER_FACTORY.newMapEntryBuilder(childSizeHint)));
    }

    public void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)(-1 == childSizeHint ? BUILDER_FACTORY.newUserMapBuilder() : BUILDER_FACTORY.newUserMapBuilder(childSizeHint)));
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)(-1 == childSizeHint ? BUILDER_FACTORY.newChoiceBuilder() : BUILDER_FACTORY.newChoiceBuilder(childSizeHint)));
    }

    public void flush() {
    }

    public void close() {
    }

    public void nextDataSchemaNode(DataSchemaNode schema) {
        this.nextSchema = Objects.requireNonNull(schema);
    }

    public void scalarValue(Object value) {
        this.currentScalar().withValue(value);
    }

    public void domSourceValue(DOMSource value) {
        this.currentScalar().withValue((Object)value);
    }

    public void endNode() {
        NormalizedNode.Builder finishedBuilder = this.builders.poll();
        Preconditions.checkState((finishedBuilder != null ? 1 : 0) != 0, (Object)"Node which should be closed does not exists.");
        NormalizedNode product = finishedBuilder.build();
        this.nextSchema = null;
        this.writeChild(product);
    }

    public boolean startAnydataNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) throws IOException {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, (NormalizedNodeBuilder)BUILDER_FACTORY.newAnydataBuilder(objectModel));
        return true;
    }

    protected final void writeChild(NormalizedNode child) {
        NormalizedNodeContainerBuilder current = this.currentContainer();
        Preconditions.checkState((current != null ? 1 : 0) != 0, (Object)"Reached top level node, which could not be closed in this writer.");
        current.addChild(Objects.requireNonNull(child));
    }

    void enter(YangInstanceIdentifier.PathArgument identifier, NormalizedNodeBuilder next) {
        this.builders.push((NormalizedNode.Builder)next.withNodeIdentifier(identifier));
        this.nextSchema = null;
    }

    protected final NormalizedNode.Builder popBuilder() {
        return this.builders.pop();
    }

    final void reset(NormalizationResultBuilder builder) {
        this.nextSchema = null;
        this.builders.clear();
        this.builders.push((NormalizedNode.Builder)builder);
    }

    private <T> LeafNode.Builder<T> leafNodeBuilder(DataSchemaNode schema) {
        LeafSchemaNode leafSchema;
        Optional interner;
        LeafNode.Builder<T> builder = this.leafNodeBuilder();
        if (schema instanceof LeafSchemaNode && (interner = LeafInterner.forSchema((LeafSchemaNode)(leafSchema = (LeafSchemaNode)schema))).isPresent()) {
            return new InterningLeafNodeBuilder(builder, (Interner)interner.orElseThrow());
        }
        return builder;
    }

    <T> // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull LeafNode.Builder<T> leafNodeBuilder() {
        return BUILDER_FACTORY.newLeafBuilder();
    }

    <T> // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull LeafSetEntryNode.Builder<T> leafsetEntryNodeBuilder() {
        return BUILDER_FACTORY.newLeafSetEntryBuilder();
    }

    private void checkDataNodeContainer() {
        NormalizedNodeContainerBuilder current = this.currentContainer();
        if (!(current instanceof NormalizationResultBuilder)) {
            Preconditions.checkArgument((boolean)(current instanceof DataContainerNodeBuilder), (Object)"Invalid nesting of data.");
        }
    }

    private NormalizedNode.Builder current() {
        return this.builders.peek();
    }

    private NormalizedNodeContainerBuilder currentContainer() {
        NormalizedNode.Builder current = this.current();
        if (current instanceof NormalizedNodeContainerBuilder) {
            NormalizedNodeContainerBuilder builder = (NormalizedNodeContainerBuilder)current;
            return builder;
        }
        if (current != null) {
            throw new IllegalStateException(current + " is not a node container");
        }
        return null;
    }

    private NormalizedNodeBuilder currentScalar() {
        NormalizedNode.Builder current = this.current();
        if (current instanceof NormalizedNodeContainerBuilder) {
            throw new IllegalStateException("Unexpected node container " + current);
        }
        if (current instanceof NormalizedNodeBuilder) {
            NormalizedNodeBuilder builder = (NormalizedNodeBuilder)current;
            return builder;
        }
        throw new IllegalStateException("Unexpected non-scalar " + current);
    }
}

