/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.leafref;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefContextBuilder;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefContextTreeBuilder;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefPath;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefYangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public final class LeafRefContext {
    private final QName currentNodeQName;
    private final SchemaPath currentNodePath;
    private final SchemaContext schemaContext;
    private final Module module;
    private final LeafRefPath leafRefTargetPath;
    private final LeafRefPath absoluteLeafRefTargetPath;
    private final String leafRefTargetPathString;
    private final boolean isReferencedBy;
    private final boolean isReferencing;
    private final Map<QName, LeafRefContext> referencingChilds;
    private final Map<QName, LeafRefContext> referencedByChilds;
    private final Map<QName, LeafRefContext> referencedByLeafRefCtx;

    LeafRefContext(LeafRefContextBuilder leafRefContextBuilder) {
        this.currentNodeQName = leafRefContextBuilder.getCurrentNodeQName();
        this.currentNodePath = leafRefContextBuilder.getCurrentNodePath();
        this.schemaContext = leafRefContextBuilder.getSchemaContext();
        this.leafRefTargetPath = leafRefContextBuilder.getLeafRefTargetPath();
        this.absoluteLeafRefTargetPath = leafRefContextBuilder.getAbsoluteLeafRefTargetPath();
        this.leafRefTargetPathString = leafRefContextBuilder.getLeafRefTargetPathString();
        this.isReferencedBy = leafRefContextBuilder.isReferencedBy();
        this.isReferencing = leafRefContextBuilder.isReferencing();
        this.referencingChilds = ImmutableMap.copyOf(leafRefContextBuilder.getReferencingChilds());
        this.referencedByChilds = ImmutableMap.copyOf(leafRefContextBuilder.getReferencedByChilds());
        this.referencedByLeafRefCtx = ImmutableMap.copyOf(leafRefContextBuilder.getAllReferencedByLeafRefCtxs());
        this.module = leafRefContextBuilder.getLeafRefContextModule();
    }

    public static LeafRefContext create(SchemaContext ctx) {
        try {
            return new LeafRefContextTreeBuilder(ctx).buildLeafRefContextTree();
        }
        catch (IOException | LeafRefYangSyntaxErrorException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasLeafRefContextChild() {
        return this.hasReferencedChild() || this.hasReferencingChild();
    }

    public boolean hasReferencedChild() {
        return !this.referencedByChilds.isEmpty();
    }

    public boolean hasReferencingChild() {
        return !this.referencingChilds.isEmpty();
    }

    public boolean isReferenced() {
        return this.isReferencedBy;
    }

    public boolean isReferencing() {
        return this.isReferencing;
    }

    public LeafRefContext getReferencingChildByName(QName name) {
        return this.referencingChilds.get(name);
    }

    public Map<QName, LeafRefContext> getReferencingChilds() {
        return this.referencingChilds;
    }

    public LeafRefContext getReferencedChildByName(QName name) {
        return this.referencedByChilds.get(name);
    }

    public Map<QName, LeafRefContext> getReferencedByChilds() {
        return this.referencedByChilds;
    }

    public SchemaPath getCurrentNodePath() {
        return this.currentNodePath;
    }

    public LeafRefPath getLeafRefTargetPath() {
        return this.leafRefTargetPath;
    }

    public String getLeafRefTargetPathString() {
        return this.leafRefTargetPathString;
    }

    public QName getNodeName() {
        return this.currentNodeQName;
    }

    SchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    public LeafRefPath getAbsoluteLeafRefTargetPath() {
        return this.absoluteLeafRefTargetPath;
    }

    public Module getLeafRefContextModule() {
        return this.module;
    }

    public LeafRefContext getReferencedByLeafRefCtxByName(QName qname) {
        return this.referencedByLeafRefCtx.get(qname);
    }

    public Map<QName, LeafRefContext> getAllReferencedByLeafRefCtxs() {
        return this.referencedByLeafRefCtx;
    }
}

