/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.leafref;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefContext;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefPath;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefUtils;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

class LeafRefContextBuilder
implements Builder<LeafRefContext> {
    private final Map<QName, LeafRefContext> referencingChildren = new HashMap<QName, LeafRefContext>();
    private final Map<QName, LeafRefContext> referencedByChildren = new HashMap<QName, LeafRefContext>();
    private final Map<QName, LeafRefContext> referencedByLeafRefCtx = new HashMap<QName, LeafRefContext>();
    private QName currentNodeQName;
    private SchemaPath currentNodePath;
    private SchemaContext schemaContext;
    private LeafRefPath leafRefTargetPath = null;
    private LeafRefPath absoluteLeafRefTargetPath = null;
    private String leafRefTargetPathString = "";
    private boolean isReferencedBy = false;
    private boolean isReferencing = false;

    LeafRefContextBuilder(QName currentNodeQName, SchemaPath currentNodePath, SchemaContext schemaContext) {
        this.currentNodeQName = currentNodeQName;
        this.currentNodePath = currentNodePath;
        this.schemaContext = schemaContext;
    }

    public LeafRefContext build() {
        LeafRefContext leafRefContext = new LeafRefContext(this);
        this.referencingChildren.clear();
        this.referencedByChildren.clear();
        this.referencedByLeafRefCtx.clear();
        return leafRefContext;
    }

    public boolean hasLeafRefContextChild() {
        return this.hasReferencedByChild() || this.hasReferencingChild();
    }

    public boolean hasReferencedByChild() {
        return !this.referencedByChildren.isEmpty();
    }

    public boolean hasReferencingChild() {
        return !this.referencingChildren.isEmpty();
    }

    public boolean isReferencedBy() {
        return this.isReferencedBy;
    }

    public void setReferencedBy(boolean referencedBy) {
        this.isReferencedBy = referencedBy;
    }

    public boolean isReferencing() {
        return this.isReferencing;
    }

    public void setReferencing(boolean referencing) {
        this.isReferencing = referencing;
    }

    public void addReferencingChild(LeafRefContext child, QName childQName) {
        this.referencingChildren.put(childQName, child);
    }

    public LeafRefContext getReferencingChildByName(QName name) {
        return this.referencingChildren.get(name);
    }

    public Map<QName, LeafRefContext> getReferencingChilds() {
        return this.referencingChildren;
    }

    public void addReferencedByChild(LeafRefContext child, QName childQName) {
        this.referencedByChildren.put(childQName, child);
    }

    public LeafRefContext getReferencedByChildByName(QName name) {
        return this.referencedByChildren.get(name);
    }

    public Map<QName, LeafRefContext> getReferencedByChilds() {
        return this.referencedByChildren;
    }

    public SchemaPath getCurrentNodePath() {
        return this.currentNodePath;
    }

    public void setCurrentNodePath(SchemaPath currentNodePath) {
        this.currentNodePath = currentNodePath;
    }

    public LeafRefPath getLeafRefTargetPath() {
        return this.leafRefTargetPath;
    }

    public void setLeafRefTargetPath(LeafRefPath leafRefPath) {
        this.leafRefTargetPath = leafRefPath;
    }

    public String getLeafRefTargetPathString() {
        return this.leafRefTargetPathString;
    }

    public void setLeafRefTargetPathString(String leafRefPathString) {
        this.leafRefTargetPathString = leafRefPathString;
    }

    public QName getCurrentNodeQName() {
        return this.currentNodeQName;
    }

    public void setCurrentNodeQName(QName currentNodeQName) {
        this.currentNodeQName = currentNodeQName;
    }

    public SchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    public void setSchemaContext(SchemaContext schemaContext) {
        this.schemaContext = schemaContext;
    }

    public LeafRefPath getAbsoluteLeafRefTargetPath() {
        if (this.isReferencing && this.absoluteLeafRefTargetPath == null) {
            this.absoluteLeafRefTargetPath = this.leafRefTargetPath.isAbsolute() ? this.leafRefTargetPath : LeafRefUtils.createAbsoluteLeafRefPath(this.leafRefTargetPath, this.currentNodePath, this.getLeafRefContextModule());
        }
        return this.absoluteLeafRefTargetPath;
    }

    public Module getLeafRefContextModule() {
        Iterator it = this.currentNodePath.getPathFromRoot().iterator();
        QNameModule qnameModule = it.hasNext() ? ((QName)it.next()).getModule() : this.currentNodeQName.getModule();
        return this.schemaContext.findModule(qnameModule).orElse(null);
    }

    public void addReferencedByLeafRefCtx(QName qname, LeafRefContext leafRef) {
        this.referencedByLeafRefCtx.put(qname, leafRef);
    }

    public LeafRefContext getReferencedByLeafRefCtxByName(QName qname) {
        return this.referencedByLeafRefCtx.get(qname);
    }

    public Map<QName, LeafRefContext> getAllReferencedByLeafRefCtxs() {
        return this.referencedByLeafRefCtx;
    }
}

