/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.leafref;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.ValueNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefContext;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefDataValidationFailedException;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefPath;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefUtils;
import org.opendaylight.yangtools.yang.data.impl.leafref.QNamePredicate;
import org.opendaylight.yangtools.yang.data.impl.leafref.QNameWithPredicate;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LeafRefValidatation {
    private static final Logger LOG = LoggerFactory.getLogger(LeafRefValidatation.class);
    private static final String FAILED = " -> FAILED";
    private static final String SUCCESS = " -> OK";
    private final Set<LeafRefContext> validatedLeafRefCtx = new HashSet<LeafRefContext>();
    private final List<String> errorsMessages = new ArrayList<String>();
    private final DataTreeCandidate tree;

    private LeafRefValidatation(DataTreeCandidate tree) {
        this.tree = tree;
    }

    public static void validate(DataTreeCandidate tree, LeafRefContext rootLeafRefCtx) throws LeafRefDataValidationFailedException {
        new LeafRefValidatation(tree).validate0(rootLeafRefCtx);
    }

    private void validate0(LeafRefContext rootLeafRefCtx) throws LeafRefDataValidationFailedException {
        for (DataTreeCandidateNode dataTreeCandidateNode : this.tree.getRootNode().getChildNodes()) {
            if (dataTreeCandidateNode.getModificationType() == ModificationType.UNMODIFIED) continue;
            YangInstanceIdentifier.PathArgument identifier = dataTreeCandidateNode.getIdentifier();
            QName childQName = identifier.getNodeType();
            LeafRefContext referencedByCtx = rootLeafRefCtx.getReferencedChildByName(childQName);
            LeafRefContext referencingCtx = rootLeafRefCtx.getReferencingChildByName(childQName);
            if (referencedByCtx == null && referencingCtx == null) continue;
            YangInstanceIdentifier yangInstanceIdentifier = YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{dataTreeCandidateNode.getIdentifier()});
            this.validateNode(dataTreeCandidateNode, referencedByCtx, referencingCtx, yangInstanceIdentifier);
        }
        if (!this.errorsMessages.isEmpty()) {
            StringBuilder message = new StringBuilder();
            int errCount = 0;
            for (String errorMessage : this.errorsMessages) {
                message.append(errorMessage);
                ++errCount;
            }
            throw new LeafRefDataValidationFailedException(message.toString(), errCount);
        }
    }

    private void validateNode(DataTreeCandidateNode node, LeafRefContext referencedByCtx, LeafRefContext referencingCtx, YangInstanceIdentifier current) {
        if (node.getModificationType() == ModificationType.WRITE && node.getDataAfter().isPresent()) {
            Optional dataAfter = node.getDataAfter();
            NormalizedNode normalizedNode = (NormalizedNode)dataAfter.get();
            this.validateNodeData(normalizedNode, referencedByCtx, referencingCtx, node.getModificationType(), current);
            return;
        }
        if (node.getModificationType() == ModificationType.DELETE && referencedByCtx != null) {
            Optional dataBefor = node.getDataBefore();
            NormalizedNode normalizedNode = (NormalizedNode)dataBefor.get();
            this.validateNodeData(normalizedNode, referencedByCtx, null, node.getModificationType(), current);
            return;
        }
        Collection childNodes = node.getChildNodes();
        for (DataTreeCandidateNode childNode : childNodes) {
            if (childNode.getModificationType() == ModificationType.UNMODIFIED) continue;
            LeafRefContext childReferencedByCtx = LeafRefValidatation.getReferencedByCtxChild(referencedByCtx, childNode);
            LeafRefContext childReferencingCtx = LeafRefValidatation.getReferencingCtxChild(referencingCtx, childNode);
            if (childReferencedByCtx == null && childReferencingCtx == null) continue;
            YangInstanceIdentifier childYangInstanceIdentifier = current.node(childNode.getIdentifier());
            this.validateNode(childNode, childReferencedByCtx, childReferencingCtx, childYangInstanceIdentifier);
        }
    }

    private static LeafRefContext getReferencingCtxChild(LeafRefContext referencingCtx, DataTreeCandidateNode childNode) {
        NormalizedNode data;
        if (referencingCtx == null) {
            return null;
        }
        QName childQName = childNode.getIdentifier().getNodeType();
        LeafRefContext childReferencingCtx = referencingCtx.getReferencingChildByName(childQName);
        if (childReferencingCtx == null && ((data = (NormalizedNode)childNode.getDataAfter().get()) instanceof MapEntryNode || data instanceof UnkeyedListEntryNode)) {
            childReferencingCtx = referencingCtx;
        }
        return childReferencingCtx;
    }

    private static LeafRefContext getReferencedByCtxChild(LeafRefContext referencedByCtx, DataTreeCandidateNode childNode) {
        NormalizedNode data;
        if (referencedByCtx == null) {
            return null;
        }
        QName childQName = childNode.getIdentifier().getNodeType();
        LeafRefContext childReferencedByCtx = referencedByCtx.getReferencedChildByName(childQName);
        if (childReferencedByCtx == null && ((data = (NormalizedNode)childNode.getDataAfter().get()) instanceof MapEntryNode || data instanceof UnkeyedListEntryNode)) {
            childReferencedByCtx = referencedByCtx;
        }
        return childReferencedByCtx;
    }

    private void validateNodeData(NormalizedNode<?, ?> node, LeafRefContext referencedByCtx, LeafRefContext referencingCtx, ModificationType modificationType, YangInstanceIdentifier current) {
        block12: {
            block13: {
                block11: {
                    if (node instanceof LeafNode) {
                        LeafNode leaf = (LeafNode)node;
                        if (referencedByCtx != null && referencedByCtx.isReferenced()) {
                            this.validateLeafRefTargetNodeData((NormalizedNode<?, ?>)leaf, referencedByCtx, modificationType);
                        }
                        if (referencingCtx != null && referencingCtx.isReferencing()) {
                            this.validateLeafRefNodeData((NormalizedNode<?, ?>)leaf, referencingCtx, modificationType, current);
                        }
                        return;
                    }
                    if (node instanceof LeafSetNode) {
                        if (referencedByCtx == null && referencingCtx == null) {
                            return;
                        }
                        LeafSetNode leafSet = (LeafSetNode)node;
                        for (NormalizedNode leafSetEntry : leafSet.getValue()) {
                            if (referencedByCtx != null && referencedByCtx.isReferenced()) {
                                this.validateLeafRefTargetNodeData(leafSetEntry, referencedByCtx, modificationType);
                            }
                            if (referencingCtx == null || !referencingCtx.isReferencing()) continue;
                            this.validateLeafRefNodeData(leafSetEntry, referencingCtx, modificationType, current);
                        }
                        return;
                    }
                    if (!(node instanceof ChoiceNode)) break block11;
                    ChoiceNode choice = (ChoiceNode)node;
                    for (DataContainerChild dataContainerChild : choice.getValue()) {
                        QName qname = dataContainerChild.getNodeType();
                        LeafRefContext childReferencedByCtx = referencedByCtx != null ? LeafRefValidatation.findReferencedByCtxUnderChoice(referencedByCtx, qname) : null;
                        LeafRefContext childReferencingCtx = referencingCtx != null ? LeafRefValidatation.findReferencingCtxUnderChoice(referencingCtx, qname) : null;
                        if (childReferencedByCtx == null && childReferencingCtx == null) continue;
                        YangInstanceIdentifier childYangInstanceIdentifier = current.node(dataContainerChild.getIdentifier());
                        this.validateNodeData((NormalizedNode<?, ?>)dataContainerChild, childReferencedByCtx, childReferencingCtx, modificationType, childYangInstanceIdentifier);
                    }
                    break block12;
                }
                if (!(node instanceof DataContainerNode)) break block13;
                DataContainerNode dataContainerNode = (DataContainerNode)node;
                for (DataContainerChild child : dataContainerNode.getValue()) {
                    QName qname = child.getNodeType();
                    LeafRefContext childReferencedByCtx = referencedByCtx != null ? referencedByCtx.getReferencedChildByName(qname) : null;
                    LeafRefContext childReferencingCtx = referencingCtx != null ? referencingCtx.getReferencingChildByName(qname) : null;
                    if (childReferencedByCtx == null && childReferencingCtx == null) continue;
                    YangInstanceIdentifier childYangInstanceIdentifier = current.node(child.getIdentifier());
                    this.validateNodeData((NormalizedNode<?, ?>)child, childReferencedByCtx, childReferencingCtx, modificationType, childYangInstanceIdentifier);
                }
                break block12;
            }
            if (!(node instanceof MapNode)) break block12;
            MapNode map = (MapNode)node;
            for (MapEntryNode mapEntry : map.getValue()) {
                YangInstanceIdentifier mapEntryYangInstanceIdentifier = current.node((YangInstanceIdentifier.PathArgument)mapEntry.getIdentifier());
                for (DataContainerChild mapEntryNode : mapEntry.getValue()) {
                    QName qname = mapEntryNode.getNodeType();
                    LeafRefContext childReferencedByCtx = referencedByCtx != null ? referencedByCtx.getReferencedChildByName(qname) : null;
                    LeafRefContext childReferencingCtx = referencingCtx != null ? referencingCtx.getReferencingChildByName(qname) : null;
                    if (childReferencedByCtx == null && childReferencingCtx == null) continue;
                    this.validateNodeData((NormalizedNode<?, ?>)mapEntryNode, childReferencedByCtx, childReferencingCtx, modificationType, mapEntryYangInstanceIdentifier.node(mapEntryNode.getIdentifier()));
                }
            }
        }
    }

    private static LeafRefContext findReferencingCtxUnderChoice(LeafRefContext referencingCtx, QName qname) {
        for (LeafRefContext child : referencingCtx.getReferencingChilds().values()) {
            LeafRefContext referencingChildByName = child.getReferencingChildByName(qname);
            if (referencingChildByName == null) continue;
            return referencingChildByName;
        }
        return null;
    }

    private static LeafRefContext findReferencedByCtxUnderChoice(LeafRefContext referencedByCtx, QName qname) {
        for (LeafRefContext child : referencedByCtx.getReferencedByChilds().values()) {
            LeafRefContext referencedByChildByName = child.getReferencedChildByName(qname);
            if (referencedByChildByName == null) continue;
            return referencedByChildByName;
        }
        return null;
    }

    private void validateLeafRefTargetNodeData(NormalizedNode<?, ?> leaf, LeafRefContext referencedByCtx, ModificationType modificationType) {
        HashMap leafRefsValues = new HashMap();
        if (this.validatedLeafRefCtx.contains(referencedByCtx)) {
            this.leafRefTargetNodeDataLog(leaf, referencedByCtx, modificationType, leafRefsValues, null);
            return;
        }
        Map<QName, LeafRefContext> allReferencedByLeafRefCtxs = referencedByCtx.getAllReferencedByLeafRefCtxs();
        for (LeafRefContext leafRefContext : allReferencedByLeafRefCtxs.values()) {
            if (!leafRefContext.isReferencing()) continue;
            HashSet<Object> values = new HashSet<Object>();
            SchemaPath leafRefNodeSchemaPath = leafRefContext.getCurrentNodePath();
            LeafRefPath leafRefNodePath = LeafRefUtils.schemaPathToLeafRefPath(leafRefNodeSchemaPath, leafRefContext.getLeafRefContextModule());
            Iterable<QNameWithPredicate> pathFromRoot = leafRefNodePath.getPathFromRoot();
            this.addValues(values, this.tree.getRootNode().getDataAfter(), pathFromRoot, null, QNameWithPredicate.ROOT);
            leafRefsValues.put(leafRefContext, values);
        }
        if (!leafRefsValues.isEmpty()) {
            HashSet<Object> leafRefTargetNodeValues = new HashSet<Object>();
            SchemaPath nodeSchemaPath = referencedByCtx.getCurrentNodePath();
            LeafRefPath nodePath = LeafRefUtils.schemaPathToLeafRefPath(nodeSchemaPath, referencedByCtx.getLeafRefContextModule());
            this.addValues(leafRefTargetNodeValues, this.tree.getRootNode().getDataAfter(), nodePath.getPathFromRoot(), null, QNameWithPredicate.ROOT);
            this.leafRefTargetNodeDataLog(leaf, referencedByCtx, modificationType, leafRefsValues, leafRefTargetNodeValues);
        } else {
            this.leafRefTargetNodeDataLog(leaf, referencedByCtx, modificationType, null, null);
        }
        this.validatedLeafRefCtx.add(referencedByCtx);
    }

    private void leafRefTargetNodeDataLog(NormalizedNode<?, ?> leaf, LeafRefContext referencedByCtx, ModificationType modificationType, Map<LeafRefContext, Set<?>> leafRefsValues, Set<Object> leafRefTargetNodeValues) {
        if (leafRefsValues != null && !leafRefsValues.isEmpty()) {
            Set<Map.Entry<LeafRefContext, Set<?>>> entrySet = leafRefsValues.entrySet();
            LOG.debug("Operation [{}] validate data of leafref TARGET node: name[{}] = value[{}]", new Object[]{modificationType, referencedByCtx.getNodeName(), leaf.getValue()});
            for (Map.Entry<LeafRefContext, Set<?>> entry : entrySet) {
                LeafRefContext leafRefContext = entry.getKey();
                Set<?> leafRefValuesSet = entry.getValue();
                for (Object leafRefsValue : leafRefValuesSet) {
                    if (leafRefTargetNodeValues != null && !leafRefTargetNodeValues.contains(leafRefsValue)) {
                        LOG.debug("Invalid leafref value [{}] allowed values {} by validation of leafref TARGET node: {} path of invalid LEAFREF node: {} leafRef target path: {} {}", new Object[]{leafRefsValue, leafRefTargetNodeValues, leaf.getNodeType(), leafRefContext.getCurrentNodePath(), leafRefContext.getAbsoluteLeafRefTargetPath(), FAILED});
                        this.errorsMessages.add(String.format("Invalid leafref value [%s] allowed values %s by validation of leafref TARGET node: %s path of invalid LEAFREF node: %s leafRef target path: %s %s", leafRefsValue, leafRefTargetNodeValues, leaf.getNodeType(), leafRefContext.getCurrentNodePath(), leafRefContext.getAbsoluteLeafRefTargetPath(), FAILED));
                        continue;
                    }
                    LOG.debug("Valid leafref value [{}] {}", leafRefsValue, (Object)SUCCESS);
                }
            }
        } else if (leafRefsValues != null) {
            LOG.debug("Operation [{}] validate data of leafref TARGET node: name[{}] = value[{}] -> SKIP: Already validated", new Object[]{modificationType, referencedByCtx.getNodeName(), leaf.getValue()});
        }
    }

    private void validateLeafRefNodeData(NormalizedNode<?, ?> leaf, LeafRefContext referencingCtx, ModificationType modificationType, YangInstanceIdentifier current) {
        HashSet<Object> values = new HashSet<Object>();
        LeafRefPath targetPath = referencingCtx.getAbsoluteLeafRefTargetPath();
        Iterable<QNameWithPredicate> pathFromRoot = targetPath.getPathFromRoot();
        this.addValues(values, this.tree.getRootNode().getDataAfter(), pathFromRoot, current, QNameWithPredicate.ROOT);
        if (!values.contains(leaf.getValue())) {
            LOG.debug("Operation [{}] validate data of LEAFREF node: name[{}] = value[{}] {}", new Object[]{modificationType, referencingCtx.getNodeName(), leaf.getValue(), FAILED});
            LOG.debug("Invalid leafref value [{}] allowed values {} of LEAFREF node: {} leafRef target path: {}", new Object[]{leaf.getValue(), values, leaf.getNodeType(), referencingCtx.getAbsoluteLeafRefTargetPath()});
            this.errorsMessages.add(String.format("Invalid leafref value [%s] allowed values %s of LEAFREF node: %s leafRef target path: %s", leaf.getValue(), values, leaf.getNodeType(), referencingCtx.getAbsoluteLeafRefTargetPath()));
        } else {
            LOG.debug("Operation [{}] validate data of LEAFREF node: name[{}] = value[{}] {}", new Object[]{modificationType, referencingCtx.getNodeName(), leaf.getValue(), SUCCESS});
        }
    }

    private void addValues(Set<Object> values, Optional<? extends NormalizedNode<?, ?>> optDataNode, Iterable<QNameWithPredicate> path, YangInstanceIdentifier current, QNameWithPredicate previousQName) {
        block18: {
            YangInstanceIdentifier.NodeIdentifier pathArgument;
            QNameWithPredicate qnameWithPredicate;
            NormalizedNode<?, ?> node;
            block17: {
                if (!optDataNode.isPresent()) {
                    return;
                }
                node = optDataNode.get();
                if (node instanceof ValueNode) {
                    values.add(node.getValue());
                    return;
                }
                if (node instanceof LeafSetNode) {
                    for (NormalizedNode entry : ((LeafSetNode)node).getValue()) {
                        values.add(entry.getValue());
                    }
                    return;
                }
                Iterator<QNameWithPredicate> iterator = path.iterator();
                if (!iterator.hasNext()) {
                    return;
                }
                qnameWithPredicate = iterator.next();
                QName qName = qnameWithPredicate.getQName();
                pathArgument = new YangInstanceIdentifier.NodeIdentifier(qName);
                if (!(node instanceof DataContainerNode)) break block17;
                DataContainerNode dataContainerNode = (DataContainerNode)node;
                Optional child = dataContainerNode.getChild((YangInstanceIdentifier.PathArgument)pathArgument);
                if (child.isPresent()) {
                    this.addValues(values, child, LeafRefValidatation.nextLevel(path), current, qnameWithPredicate);
                } else {
                    for (ChoiceNode choiceNode : LeafRefValidatation.getChoiceNodes(dataContainerNode)) {
                        this.addValues(values, Optional.of(choiceNode), path, current, qnameWithPredicate);
                    }
                }
                break block18;
            }
            if (!(node instanceof MapNode)) break block18;
            MapNode map = (MapNode)node;
            List<QNamePredicate> qNamePredicates = previousQName.getQNamePredicates();
            if (qNamePredicates.isEmpty() || current == null) {
                Collection value = map.getValue();
                for (MapEntryNode mapEntryNode : value) {
                    Optional child = mapEntryNode.getChild((YangInstanceIdentifier.PathArgument)pathArgument);
                    if (child.isPresent()) {
                        this.addValues(values, child, LeafRefValidatation.nextLevel(path), current, qnameWithPredicate);
                        continue;
                    }
                    for (ChoiceNode choiceNode : LeafRefValidatation.getChoiceNodes(mapEntryNode)) {
                        this.addValues(values, Optional.of(choiceNode), path, current, qnameWithPredicate);
                    }
                }
            } else {
                HashMap keyValues = new HashMap();
                for (QNamePredicate predicate : qNamePredicates) {
                    QName identifier = (QName)predicate.getIdentifier();
                    LeafRefPath predicatePathKeyExpression = predicate.getPathKeyExpression();
                    Set<?> pathKeyExprValues = this.getPathKeyExpressionValues(predicatePathKeyExpression, current);
                    keyValues.put(identifier, pathKeyExprValues);
                }
                for (MapEntryNode mapEntryNode : map.getValue()) {
                    if (!LeafRefValidatation.isMatchingPredicate(mapEntryNode, keyValues)) continue;
                    Optional child = mapEntryNode.getChild((YangInstanceIdentifier.PathArgument)pathArgument);
                    if (child.isPresent()) {
                        this.addValues(values, child, LeafRefValidatation.nextLevel(path), current, qnameWithPredicate);
                        continue;
                    }
                    for (ChoiceNode choiceNode : LeafRefValidatation.getChoiceNodes(mapEntryNode)) {
                        this.addValues(values, Optional.of(choiceNode), path, current, qnameWithPredicate);
                    }
                }
            }
        }
    }

    private static Iterable<ChoiceNode> getChoiceNodes(DataContainerNode<?> dataContainerNode) {
        ArrayList<ChoiceNode> choiceNodes = new ArrayList<ChoiceNode>();
        for (DataContainerChild child : dataContainerNode.getValue()) {
            if (!(child instanceof ChoiceNode)) continue;
            choiceNodes.add((ChoiceNode)child);
        }
        return choiceNodes;
    }

    private static boolean isMatchingPredicate(MapEntryNode mapEntryNode, Map<QName, Set<?>> allowedKeyValues) {
        for (Map.Entry entryKeyValue : mapEntryNode.getIdentifier().getKeyValues().entrySet()) {
            Set<?> allowedValues = allowedKeyValues.get(entryKeyValue.getKey());
            if (allowedValues == null || allowedValues.contains(entryKeyValue.getValue())) continue;
            return false;
        }
        return true;
    }

    private Set<?> getPathKeyExpressionValues(LeafRefPath predicatePathKeyExpression, YangInstanceIdentifier current) {
        Optional<NormalizedNode<?, ?>> parent = LeafRefValidatation.findParentNode(this.tree.getRootNode().getDataAfter(), current);
        Iterable<QNameWithPredicate> predicatePathExpr = predicatePathKeyExpression.getPathFromRoot();
        Iterable<QNameWithPredicate> predicatePath = LeafRefValidatation.nextLevel(predicatePathExpr);
        HashSet<Object> values = new HashSet<Object>();
        if (parent != null) {
            this.addValues(values, parent, predicatePath, null, QNameWithPredicate.ROOT);
        }
        return values;
    }

    private static Optional<NormalizedNode<?, ?>> findParentNode(Optional<NormalizedNode<?, ?>> root, YangInstanceIdentifier path) {
        Optional currentNode = root;
        Iterator pathIterator = path.getPathArguments().iterator();
        while (pathIterator.hasNext()) {
            YangInstanceIdentifier.PathArgument childPathArgument = (YangInstanceIdentifier.PathArgument)pathIterator.next();
            if (pathIterator.hasNext() && currentNode.isPresent()) {
                currentNode = NormalizedNodes.getDirectChild(currentNode.get(), (YangInstanceIdentifier.PathArgument)childPathArgument);
                continue;
            }
            return currentNode;
        }
        return Optional.empty();
    }

    private static Iterable<QNameWithPredicate> nextLevel(Iterable<QNameWithPredicate> path) {
        return Iterables.skip(path, (int)1);
    }
}

