/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.InstanceIdToNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableChoiceNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapNodeBuilder;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public final class ImmutableNodes {
    private ImmutableNodes() {
        throw new UnsupportedOperationException("Utilities class should not be instantiated");
    }

    public static CollectionNodeBuilder<MapEntryNode, MapNode> mapNodeBuilder() {
        return ImmutableMapNodeBuilder.create();
    }

    public static CollectionNodeBuilder<MapEntryNode, MapNode> mapNodeBuilder(QName name) {
        return ImmutableMapNodeBuilder.create().withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier.create((QName)name));
    }

    public static <T> LeafNode<T> leafNode(YangInstanceIdentifier.NodeIdentifier name, T value) {
        return (LeafNode)ImmutableLeafNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)name).withValue(value).build();
    }

    public static <T> LeafNode<T> leafNode(QName name, T value) {
        return ImmutableNodes.leafNode(YangInstanceIdentifier.NodeIdentifier.create((QName)name), value);
    }

    public static DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> mapEntryBuilder(QName nodeName, QName keyName, Object keyValue) {
        return ImmutableMapEntryNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifierWithPredicates(nodeName, keyName, keyValue)).withChild((DataContainerChild)ImmutableNodes.leafNode(keyName, keyValue));
    }

    public static DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> mapEntryBuilder() {
        return ImmutableMapEntryNodeBuilder.create();
    }

    public static MapEntryNode mapEntry(QName nodeName, QName keyName, Object keyValue) {
        return (MapEntryNode)ImmutableNodes.mapEntryBuilder(nodeName, keyName, keyValue).build();
    }

    public static ContainerNode containerNode(QName name) {
        return (ContainerNode)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)name)).build();
    }

    public static ChoiceNode choiceNode(QName name) {
        return (ChoiceNode)ImmutableChoiceNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)name)).build();
    }

    public static NormalizedNode<?, ?> fromInstanceId(SchemaContext ctx, YangInstanceIdentifier id) {
        return ImmutableNodes.fromInstanceId(ctx, id, Optional.empty(), Optional.empty());
    }

    public static NormalizedNode<?, ?> fromInstanceId(SchemaContext ctx, YangInstanceIdentifier id, NormalizedNode<?, ?> deepestElement) {
        return ImmutableNodes.fromInstanceId(ctx, id, Optional.of(deepestElement), Optional.empty());
    }

    public static NormalizedNode<?, ?> fromInstanceId(SchemaContext ctx, YangInstanceIdentifier id, Optional<NormalizedNode<?, ?>> deepestElement, Optional<Map.Entry<QName, ModifyAction>> operation) {
        YangInstanceIdentifier.PathArgument topLevelElement = (YangInstanceIdentifier.PathArgument)id.getPathArguments().get(0);
        DataSchemaNode dataChildByName = ctx.getDataChildByName(topLevelElement.getNodeType());
        Preconditions.checkNotNull((Object)dataChildByName, (String)"Cannot find %s node in schema context. Instance identifier has to start from root", (Object)topLevelElement);
        InstanceIdToNodes<?> instanceIdToNodes = InstanceIdToNodes.fromSchemaAndQNameChecked((DataNodeContainer)ctx, topLevelElement.getNodeType());
        return instanceIdToNodes.create(id, deepestElement, operation);
    }
}

