/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.valid.DataNodeContainerValidator;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.valid.DataValidationException;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

public final class ImmutableMapEntryNodeSchemaAwareBuilder
extends ImmutableMapEntryNodeBuilder {
    private final ListSchemaNode schema;
    private final DataNodeContainerValidator validator;

    ImmutableMapEntryNodeSchemaAwareBuilder(ListSchemaNode schema) {
        this.schema = (ListSchemaNode)Preconditions.checkNotNull((Object)schema);
        this.validator = new DataNodeContainerValidator((DataNodeContainer)schema);
    }

    public ImmutableMapEntryNodeBuilder withNodeIdentifier(YangInstanceIdentifier.NodeIdentifierWithPredicates withNodeIdentifier) {
        throw new UnsupportedOperationException("Node identifier created from schema");
    }

    @Override
    public DataContainerNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> withChild(DataContainerChild<?, ?> child) {
        this.validator.validateChild(child.getIdentifier());
        return super.withChild((DataContainerChild)child);
    }

    @Override
    public MapEntryNode build() {
        super.withNodeIdentifier((YangInstanceIdentifier.PathArgument)this.constructNodeIdentifier());
        return super.build();
    }

    private YangInstanceIdentifier.NodeIdentifierWithPredicates constructNodeIdentifier() {
        Collection<Object> keys = this.schema.getKeyDefinition();
        if (keys.isEmpty()) {
            keys = this.childrenQNamesToPaths.keySet();
        }
        LinkedHashMap<QName, Object> keysToValues = new LinkedHashMap<QName, Object>();
        for (QName qName : keys) {
            DataContainerChild<YangInstanceIdentifier.PathArgument, ?> valueForKey = this.getChild((YangInstanceIdentifier.PathArgument)this.childrenQNamesToPaths.get(qName));
            DataValidationException.checkListKey(valueForKey, qName, new YangInstanceIdentifier.NodeIdentifierWithPredicates(this.schema.getQName(), keysToValues));
            keysToValues.put(qName, valueForKey.getValue());
        }
        return new YangInstanceIdentifier.NodeIdentifierWithPredicates(this.schema.getQName(), keysToValues);
    }

    public static DataContainerNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> create(ListSchemaNode schema) {
        return new ImmutableMapEntryNodeSchemaAwareBuilder(schema);
    }
}

