/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedMapNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableOrderedMapNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.valid.DataValidationException;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

public class ImmutableOrderedMapNodeSchemaAwareBuilder
extends ImmutableOrderedMapNodeBuilder {
    private final ListSchemaNode schema;

    protected ImmutableOrderedMapNodeSchemaAwareBuilder(ListSchemaNode schema) {
        this.schema = (ListSchemaNode)Preconditions.checkNotNull((Object)schema);
        super.withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()));
    }

    protected ImmutableOrderedMapNodeSchemaAwareBuilder(ListSchemaNode schema, ImmutableOrderedMapNodeBuilder.ImmutableOrderedMapNode node) {
        super(node);
        this.schema = (ListSchemaNode)Preconditions.checkNotNull((Object)schema);
        super.withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()));
    }

    public static CollectionNodeBuilder<MapEntryNode, OrderedMapNode> create(ListSchemaNode schema) {
        return new ImmutableOrderedMapNodeSchemaAwareBuilder(schema);
    }

    public static CollectionNodeBuilder<MapEntryNode, OrderedMapNode> create(ListSchemaNode schema, MapNode node) {
        if (!(node instanceof ImmutableOrderedMapNodeBuilder.ImmutableOrderedMapNode)) {
            throw new UnsupportedOperationException(String.format("Cannot initialize from class %s", node.getClass()));
        }
        return new ImmutableOrderedMapNodeSchemaAwareBuilder(schema, (ImmutableOrderedMapNodeBuilder.ImmutableOrderedMapNode)node);
    }

    @Override
    public CollectionNodeBuilder<MapEntryNode, OrderedMapNode> withChild(MapEntryNode child) {
        DataValidationException.checkLegalChild(this.schema.getQName().equals((Object)child.getNodeType()), (YangInstanceIdentifier.PathArgument)child.getIdentifier(), (DataSchemaNode)this.schema, Collections.singleton(this.schema.getQName()));
        return super.withChild(child);
    }

    @Override
    public CollectionNodeBuilder<MapEntryNode, OrderedMapNode> withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        throw new UnsupportedOperationException("Node identifier created from schema");
    }
}

