/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.nodes;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.util.ImmutableOffsetMap;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.AbstractImmutableNormalizedNode;

public abstract class AbstractImmutableDataContainerNode<K extends YangInstanceIdentifier.PathArgument>
extends AbstractImmutableNormalizedNode<K, Collection<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>>>
implements Immutable,
DataContainerNode<K> {
    private final Map<YangInstanceIdentifier.PathArgument, DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> children;

    public AbstractImmutableDataContainerNode(Map<YangInstanceIdentifier.PathArgument, DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> children, K nodeIdentifier) {
        super(nodeIdentifier);
        this.children = ImmutableOffsetMap.unorderedCopyOf(children);
    }

    public final Optional<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> getChild(YangInstanceIdentifier.PathArgument child) {
        return Optional.ofNullable(this.children.get(child));
    }

    public final Collection<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> getValue() {
        return this.children.values();
    }

    @Override
    protected int valueHashCode() {
        return this.children.hashCode();
    }

    public final Map<YangInstanceIdentifier.PathArgument, DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> getChildren() {
        return this.children;
    }

    @Override
    protected boolean valueEquals(AbstractImmutableNormalizedNode<?, ?> other) {
        return other instanceof AbstractImmutableDataContainerNode && this.children.equals(((AbstractImmutableDataContainerNode)other).children);
    }
}

