/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.nodes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.AttributesContainer;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.AbstractImmutableNormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.AbstractImmutableNormalizedValueNode;

public abstract class AbstractImmutableNormalizedValueAttrNode<K extends YangInstanceIdentifier.PathArgument, V>
extends AbstractImmutableNormalizedValueNode<K, V>
implements AttributesContainer {
    private final Map<QName, String> attributes;

    protected AbstractImmutableNormalizedValueAttrNode(K nodeIdentifier, V value, Map<QName, String> attributes) {
        super(nodeIdentifier, value);
        this.attributes = ImmutableMap.copyOf(attributes);
    }

    public final Map<QName, String> getAttributes() {
        return this.attributes;
    }

    public final Object getAttributeValue(QName value) {
        return this.attributes.get(value);
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("attributes", this.attributes);
    }

    @Override
    protected int valueHashCode() {
        Object local = this.value();
        int result = local != null ? local.hashCode() : 1;
        return result;
    }

    @Override
    protected boolean valueEquals(AbstractImmutableNormalizedNode<?, ?> other) {
        return Objects.deepEquals(this.value(), other.getValue());
    }
}

