/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.DeleteLeafCandidateNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.RecursiveDeleteCandidateNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.RecursiveReplaceCandidateNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.RecursiveUnmodifiedCandidateNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.RecursiveWriteCandidateNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ReplaceLeafCandidateNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.UnmodifiedLeafCandidateNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.WriteLeafCandidateNode;

abstract class AbstractRecursiveCandidateNode
extends AbstractDataTreeCandidateNode {
    protected AbstractRecursiveCandidateNode(NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> data) {
        super(data);
    }

    static DataTreeCandidateNode deleteNode(NormalizedNode<?, ?> data) {
        if (data instanceof NormalizedNodeContainer) {
            return new RecursiveDeleteCandidateNode((NormalizedNodeContainer)data);
        }
        return new DeleteLeafCandidateNode(data);
    }

    static DataTreeCandidateNode replaceNode(NormalizedNode<?, ?> oldData, NormalizedNode<?, ?> newData) {
        if (AbstractRecursiveCandidateNode.isContainer(oldData)) {
            return new RecursiveReplaceCandidateNode((NormalizedNodeContainer)oldData, (NormalizedNodeContainer)newData);
        }
        return new ReplaceLeafCandidateNode(oldData, newData);
    }

    static DataTreeCandidateNode unmodifiedNode(NormalizedNode<?, ?> data) {
        if (data instanceof NormalizedNodeContainer) {
            return new RecursiveUnmodifiedCandidateNode((NormalizedNodeContainer)data);
        }
        return new UnmodifiedLeafCandidateNode(data);
    }

    static DataTreeCandidateNode writeNode(NormalizedNode<?, ?> data) {
        if (data instanceof NormalizedNodeContainer) {
            return new RecursiveWriteCandidateNode((NormalizedNodeContainer)data);
        }
        return new WriteLeafCandidateNode(data);
    }

    protected static boolean isContainer(NormalizedNode<?, ?> data) {
        return data instanceof NormalizedNodeContainer;
    }

    public final DataTreeCandidateNode getModifiedChild(YangInstanceIdentifier.PathArgument identifier) {
        Optional potential = this.getData().getChild(identifier);
        if (potential.isPresent()) {
            return this.createChild((NormalizedNode)potential.get());
        }
        return null;
    }

    @Nonnull
    public final Collection<DataTreeCandidateNode> getChildNodes() {
        return Collections2.transform((Collection)this.getData().getValue(), this::createChild);
    }

    private DataTreeCandidateNode createChild(NormalizedNode<?, ?> childData) {
        if (AbstractRecursiveCandidateNode.isContainer(childData)) {
            return this.createContainer((NormalizedNodeContainer)childData);
        }
        return this.createLeaf(childData);
    }

    abstract DataTreeCandidateNode createContainer(NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> var1);

    abstract DataTreeCandidateNode createLeaf(NormalizedNode<?, ?> var1);
}

