/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.IncorrectDataStructureException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNodeFactory;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ChildTrackingPolicy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.LogicalOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.NodeModification;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

abstract class AbstractValueNodeModificationStrategy<T extends DataSchemaNode>
extends SchemaAwareApplyOperation {
    private final Class<? extends NormalizedNode<?, ?>> nodeClass;
    private final T schema;

    protected AbstractValueNodeModificationStrategy(T schema, Class<? extends NormalizedNode<?, ?>> nodeClass) {
        this.nodeClass = (Class)Preconditions.checkNotNull(nodeClass);
        this.schema = schema;
    }

    @Override
    protected final void verifyStructure(NormalizedNode<?, ?> writtenValue, boolean verifyChildren) {
        Preconditions.checkArgument((boolean)this.nodeClass.isInstance(writtenValue), (String)"Node should must be of type %s", this.nodeClass);
    }

    @Override
    public final Optional<ModificationApplyOperation> getChild(YangInstanceIdentifier.PathArgument child) {
        throw new UnsupportedOperationException("Node " + this.schema.getPath() + "is leaf type node. Child nodes not allowed");
    }

    @Override
    protected final ChildTrackingPolicy getChildPolicy() {
        return ChildTrackingPolicy.NONE;
    }

    @Override
    protected final TreeNode applyTouch(ModifiedNode modification, TreeNode currentMeta, Version version) {
        throw new UnsupportedOperationException("Node " + this.schema.getPath() + "is leaf type node. Subtree change is not allowed.");
    }

    @Override
    protected final TreeNode applyMerge(ModifiedNode modification, TreeNode currentMeta, Version version) {
        this.verifyStructure(modification.getWrittenValue(), true);
        modification.resolveModificationType(ModificationType.WRITE);
        return this.applyWrite(modification, null, version);
    }

    @Override
    protected final TreeNode applyWrite(ModifiedNode modification, Optional<TreeNode> currentMeta, Version version) {
        return TreeNodeFactory.createTreeNode(modification.getWrittenValue(), (Version)version);
    }

    @Override
    protected final void checkTouchApplicable(YangInstanceIdentifier path, NodeModification modification, Optional<TreeNode> current, Version version) throws IncorrectDataStructureException {
        throw new IncorrectDataStructureException(path, "Subtree modification is not allowed.");
    }

    @Override
    void mergeIntoModifiedNode(ModifiedNode node, NormalizedNode<?, ?> value, Version version) {
        switch (node.getOperation()) {
            case DELETE: 
            case WRITE: {
                node.write(value);
                break;
            }
            default: {
                node.updateValue(LogicalOperation.MERGE, value);
            }
        }
    }

    @Override
    void recursivelyVerifyStructure(NormalizedNode<?, ?> value) {
        this.verifyStructure(value, false);
    }
}

