/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.api.schema.tree.CursorAwareDataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshotCursor;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractCursorAware;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeModification;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeSnapshotCursor;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.RootModificationApplyOperation;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

final class InMemoryDataTreeSnapshot
extends AbstractCursorAware
implements CursorAwareDataTreeSnapshot {
    private final RootModificationApplyOperation applyOper;
    private final SchemaContext schemaContext;
    private final TreeNode rootNode;

    InMemoryDataTreeSnapshot(SchemaContext schemaContext, TreeNode rootNode, RootModificationApplyOperation applyOper) {
        this.schemaContext = Objects.requireNonNull(schemaContext);
        this.rootNode = Objects.requireNonNull(rootNode);
        this.applyOper = Objects.requireNonNull(applyOper);
    }

    TreeNode getRootNode() {
        return this.rootNode;
    }

    SchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    public Optional<NormalizedNode<?, ?>> readNode(YangInstanceIdentifier path) {
        return NormalizedNodes.findNode((NormalizedNode)this.rootNode.getData(), (YangInstanceIdentifier)path);
    }

    public InMemoryDataTreeModification newModification() {
        return new InMemoryDataTreeModification(this, this.applyOper);
    }

    public DataTreeSnapshotCursor createCursor(@Nonnull YangInstanceIdentifier path) {
        Optional maybeRoot = NormalizedNodes.findNode((NormalizedNode)this.rootNode.getData(), (YangInstanceIdentifier)path);
        if (!maybeRoot.isPresent()) {
            return null;
        }
        NormalizedNode root = (NormalizedNode)maybeRoot.get();
        Preconditions.checkArgument((boolean)(root instanceof NormalizedNodeContainer), (String)"Child %s is not a container", (Object)path);
        return this.openCursor(new InMemoryDataTreeSnapshotCursor(this, path, (NormalizedNodeContainer)root));
    }

    public String toString() {
        return this.rootNode.getSubtreeVersion().toString();
    }
}

