/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.TreeType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraintAware;
import org.opendaylight.yangtools.yang.model.api.MandatoryAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MandatoryLeafEnforcer
implements Immutable {
    private static final Logger LOG = LoggerFactory.getLogger(MandatoryLeafEnforcer.class);
    private static final MandatoryLeafEnforcer NOOP_ENFORCER = new MandatoryLeafEnforcer(){

        @Override
        void enforceOnData(NormalizedNode<?, ?> normalizedNode) {
        }
    };

    MandatoryLeafEnforcer() {
    }

    final void enforceOnTreeNode(TreeNode tree) {
        this.enforceOnData(tree.getData());
    }

    abstract void enforceOnData(NormalizedNode<?, ?> var1);

    private static void findMandatoryNodes(ImmutableCollection.Builder<YangInstanceIdentifier> builder, YangInstanceIdentifier id, DataNodeContainer schema, TreeType type) {
        for (DataSchemaNode child : schema.getChildNodes()) {
            boolean needEnforce;
            if (!SchemaAwareApplyOperation.belongsToTree(type, child)) continue;
            if (child instanceof ContainerSchemaNode) {
                ContainerSchemaNode container = (ContainerSchemaNode)child;
                if (container.isPresenceContainer()) continue;
                MandatoryLeafEnforcer.findMandatoryNodes(builder, id.node((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)child.getQName())), (DataNodeContainer)container, type);
                continue;
            }
            boolean bl = needEnforce = child instanceof MandatoryAware && ((MandatoryAware)child).isMandatory();
            if (!needEnforce && child instanceof ElementCountConstraintAware) {
                needEnforce = ((ElementCountConstraintAware)child).getElementCountConstraint().map(constraint -> {
                    Integer min = constraint.getMinElements();
                    return min != null && min > 0;
                }).orElse(Boolean.FALSE);
            }
            if (!needEnforce) continue;
            YangInstanceIdentifier childId = id.node((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)child.getQName()));
            LOG.debug("Adding mandatory child {}", (Object)childId);
            builder.add((Object)childId.toOptimized());
        }
    }

    static MandatoryLeafEnforcer forContainer(DataNodeContainer schema, DataTreeConfiguration treeConfig) {
        if (!treeConfig.isMandatoryNodesValidationEnabled()) {
            return NOOP_ENFORCER;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        MandatoryLeafEnforcer.findMandatoryNodes((ImmutableCollection.Builder<YangInstanceIdentifier>)builder, YangInstanceIdentifier.EMPTY, schema, treeConfig.getTreeType());
        ImmutableCollection mandatoryNodes = builder.build();
        return mandatoryNodes.isEmpty() ? NOOP_ENFORCER : new Strict((Collection<YangInstanceIdentifier>)mandatoryNodes);
    }

    private static final class Strict
    extends MandatoryLeafEnforcer {
        private final Collection<YangInstanceIdentifier> mandatoryNodes;

        Strict(Collection<YangInstanceIdentifier> mandatoryNodes) {
            this.mandatoryNodes = (Collection)Preconditions.checkNotNull(mandatoryNodes);
        }

        @Override
        void enforceOnData(NormalizedNode<?, ?> data) {
            for (YangInstanceIdentifier id : this.mandatoryNodes) {
                Optional descandant = NormalizedNodes.findNode(data, (YangInstanceIdentifier)id);
                Preconditions.checkArgument((boolean)descandant.isPresent(), (String)"Node %s is missing mandatory descendant %s", (Object)data.getIdentifier(), (Object)id);
            }
        }
    }
}

