/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableOrderedMapNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ChildTrackingPolicy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ListEntryModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

final class OrderedMapModificationStrategy
extends AbstractNodeContainerModificationStrategy {
    private final Optional<ModificationApplyOperation> entryStrategy;

    OrderedMapModificationStrategy(ListSchemaNode schema, DataTreeConfiguration treeConfig) {
        super(OrderedMapNode.class, treeConfig);
        this.entryStrategy = Optional.of(new ListEntryModificationStrategy(schema, treeConfig));
    }

    @Override
    protected ChildTrackingPolicy getChildPolicy() {
        return ChildTrackingPolicy.ORDERED;
    }

    @Override
    protected NormalizedNodeContainerBuilder createBuilder(NormalizedNode<?, ?> original) {
        Preconditions.checkArgument((boolean)(original instanceof OrderedMapNode));
        return ImmutableOrderedMapNodeBuilder.create((MapNode)((OrderedMapNode)original));
    }

    @Override
    protected NormalizedNode<?, ?> createEmptyValue(NormalizedNode<?, ?> original) {
        Preconditions.checkArgument((boolean)(original instanceof OrderedMapNode));
        return ImmutableOrderedMapNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)((OrderedMapNode)original).getIdentifier()).build();
    }

    @Override
    public Optional<ModificationApplyOperation> getChild(YangInstanceIdentifier.PathArgument identifier) {
        return identifier instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates ? this.entryStrategy : Optional.empty();
    }

    public String toString() {
        return "OrderedMapModificationStrategy [entry=" + this.entryStrategy + "]";
    }
}

