/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ConflictingModificationAppliedException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.TreeType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AugmentationModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ChildTrackingPolicy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ChoiceModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.LeafModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.MinMaxElementsValidation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.NodeModification;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.OrderedLeafSetModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.OrderedMapModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.PresenceContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.StructuralContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.UnkeyedListModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.UnorderedLeafSetModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.UnorderedMapModificationStrategy;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SchemaAwareApplyOperation
extends ModificationApplyOperation {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaAwareApplyOperation.class);

    SchemaAwareApplyOperation() {
    }

    public static ModificationApplyOperation from(DataSchemaNode schemaNode, DataTreeConfiguration treeConfig) {
        if (treeConfig.getTreeType() == TreeType.CONFIGURATION) {
            Preconditions.checkArgument((boolean)schemaNode.isConfiguration(), (String)"Supplied %s does not belongs to configuration tree.", (Object)schemaNode.getPath());
        }
        if (schemaNode instanceof ContainerSchemaNode) {
            ContainerSchemaNode containerSchema = (ContainerSchemaNode)schemaNode;
            if (containerSchema.isPresenceContainer()) {
                return new PresenceContainerModificationStrategy(containerSchema, treeConfig);
            }
            return new StructuralContainerModificationStrategy(containerSchema, treeConfig);
        }
        if (schemaNode instanceof ListSchemaNode) {
            return SchemaAwareApplyOperation.fromListSchemaNode((ListSchemaNode)schemaNode, treeConfig);
        }
        if (schemaNode instanceof ChoiceSchemaNode) {
            return new ChoiceModificationStrategy((ChoiceSchemaNode)schemaNode, treeConfig);
        }
        if (schemaNode instanceof LeafListSchemaNode) {
            return SchemaAwareApplyOperation.fromLeafListSchemaNode((LeafListSchemaNode)schemaNode, treeConfig);
        }
        if (schemaNode instanceof LeafSchemaNode) {
            return new LeafModificationStrategy((LeafSchemaNode)schemaNode);
        }
        throw new IllegalArgumentException("Not supported schema node type for " + schemaNode.getClass());
    }

    public static SchemaAwareApplyOperation from(DataNodeContainer resolvedTree, AugmentationTarget augSchemas, YangInstanceIdentifier.AugmentationIdentifier identifier, DataTreeConfiguration treeConfig) {
        for (AugmentationSchemaNode potential : augSchemas.getAvailableAugmentations()) {
            for (DataSchemaNode child : potential.getChildNodes()) {
                if (!identifier.getPossibleChildNames().contains(child.getQName())) continue;
                return new AugmentationModificationStrategy(potential, resolvedTree, treeConfig);
            }
        }
        return null;
    }

    public static void checkConflicting(YangInstanceIdentifier path, boolean condition, String message) throws ConflictingModificationAppliedException {
        if (!condition) {
            throw new ConflictingModificationAppliedException(path, message);
        }
    }

    private static SchemaAwareApplyOperation fromListSchemaNode(ListSchemaNode schemaNode, DataTreeConfiguration treeConfig) {
        List keyDefinition = schemaNode.getKeyDefinition();
        SchemaAwareApplyOperation op = keyDefinition == null || keyDefinition.isEmpty() ? new UnkeyedListModificationStrategy(schemaNode, treeConfig) : (schemaNode.isUserOrdered() ? new OrderedMapModificationStrategy(schemaNode, treeConfig) : new UnorderedMapModificationStrategy(schemaNode, treeConfig));
        return MinMaxElementsValidation.from(op, (DataSchemaNode)schemaNode);
    }

    private static SchemaAwareApplyOperation fromLeafListSchemaNode(LeafListSchemaNode schemaNode, DataTreeConfiguration treeConfig) {
        AbstractNodeContainerModificationStrategy op = schemaNode.isUserOrdered() ? new OrderedLeafSetModificationStrategy(schemaNode, treeConfig) : new UnorderedLeafSetModificationStrategy(schemaNode, treeConfig);
        return MinMaxElementsValidation.from(op, (DataSchemaNode)schemaNode);
    }

    protected static void checkNotConflicting(YangInstanceIdentifier path, TreeNode original, TreeNode current) throws ConflictingModificationAppliedException {
        SchemaAwareApplyOperation.checkConflicting(path, original.getVersion().equals(current.getVersion()), "Node was replaced by other transaction.");
        SchemaAwareApplyOperation.checkConflicting(path, original.getSubtreeVersion().equals(current.getSubtreeVersion()), "Node children was modified by other transaction");
    }

    protected final ModificationApplyOperation resolveChildOperation(YangInstanceIdentifier.PathArgument child) {
        Optional<ModificationApplyOperation> potential = this.getChild(child);
        Preconditions.checkArgument((boolean)potential.isPresent(), (String)"Operation for child %s is not defined.", (Object)child);
        return potential.get();
    }

    @Override
    final void checkApplicable(YangInstanceIdentifier path, NodeModification modification, Optional<TreeNode> current, Version version) throws DataValidationFailedException {
        switch (modification.getOperation()) {
            case DELETE: {
                SchemaAwareApplyOperation.checkDeleteApplicable(modification, current);
                break;
            }
            case TOUCH: {
                this.checkTouchApplicable(path, modification, current, version);
                break;
            }
            case WRITE: {
                this.checkWriteApplicable(path, modification, current, version);
                break;
            }
            case MERGE: {
                this.checkMergeApplicable(path, modification, current, version);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Suplied modification type " + (Object)((Object)modification.getOperation()) + " is not supported.");
            }
        }
    }

    protected void checkMergeApplicable(YangInstanceIdentifier path, NodeModification modification, Optional<TreeNode> current, Version version) throws DataValidationFailedException {
        Optional<TreeNode> original = modification.getOriginal();
        if (original.isPresent() && current.isPresent() && !original.get().getData().equals(current.get().getData())) {
            SchemaAwareApplyOperation.checkNotConflicting(path, original.get(), current.get());
        }
    }

    protected void checkWriteApplicable(YangInstanceIdentifier path, NodeModification modification, Optional<TreeNode> current, Version version) throws DataValidationFailedException {
        Optional<TreeNode> original = modification.getOriginal();
        if (original.isPresent() && current.isPresent()) {
            SchemaAwareApplyOperation.checkNotConflicting(path, original.get(), current.get());
        } else {
            if (original.isPresent()) {
                throw new ConflictingModificationAppliedException(path, "Node was deleted by other transaction.");
            }
            if (current.isPresent()) {
                throw new ConflictingModificationAppliedException(path, "Node was created by other transaction.");
            }
        }
    }

    private static void checkDeleteApplicable(NodeModification modification, Optional<TreeNode> current) {
        if (!current.isPresent()) {
            LOG.trace("Delete operation turned to no-op on missing node {}", (Object)modification);
        }
    }

    @Override
    protected ChildTrackingPolicy getChildPolicy() {
        return ChildTrackingPolicy.UNORDERED;
    }

    @Override
    final Optional<TreeNode> apply(ModifiedNode modification, Optional<TreeNode> currentMeta, Version version) {
        switch (modification.getOperation()) {
            case DELETE: {
                modification.resolveModificationType(currentMeta.isPresent() ? ModificationType.DELETE : ModificationType.UNMODIFIED);
                return modification.setSnapshot(Optional.empty());
            }
            case TOUCH: {
                Preconditions.checkArgument((boolean)currentMeta.isPresent(), (String)"Metadata not available for modification %s", (Object)modification);
                return modification.setSnapshot(Optional.of(this.applyTouch(modification, currentMeta.get(), version)));
            }
            case MERGE: {
                TreeNode result;
                if (!currentMeta.isPresent()) {
                    modification.resolveModificationType(ModificationType.WRITE);
                    result = this.applyWrite(modification, currentMeta, version);
                    this.verifyStructure(result.getData(), true);
                } else {
                    result = this.applyMerge(modification, currentMeta.get(), version);
                }
                return modification.setSnapshot(Optional.of(result));
            }
            case WRITE: {
                modification.resolveModificationType(ModificationType.WRITE);
                return modification.setSnapshot(Optional.of(this.applyWrite(modification, currentMeta, version)));
            }
            case NONE: {
                modification.resolveModificationType(ModificationType.UNMODIFIED);
                return currentMeta;
            }
        }
        throw new IllegalArgumentException("Provided modification type is not supported.");
    }

    protected abstract TreeNode applyMerge(ModifiedNode var1, TreeNode var2, Version var3);

    protected abstract TreeNode applyWrite(ModifiedNode var1, Optional<TreeNode> var2, Version var3);

    protected abstract TreeNode applyTouch(ModifiedNode var1, TreeNode var2, Version var3);

    protected abstract void checkTouchApplicable(YangInstanceIdentifier var1, NodeModification var2, Optional<TreeNode> var3, Version var4) throws DataValidationFailedException;

    static boolean belongsToTree(TreeType treeType, DataSchemaNode node) {
        return treeType == TreeType.OPERATIONAL || node.isConfiguration();
    }
}

