/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ListEntryModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

final class UnorderedMapModificationStrategy
extends AbstractNodeContainerModificationStrategy {
    private final Optional<ModificationApplyOperation> entryStrategy;

    UnorderedMapModificationStrategy(ListSchemaNode schema, DataTreeConfiguration treeConfig) {
        super(MapNode.class, treeConfig);
        this.entryStrategy = Optional.of(new ListEntryModificationStrategy(schema, treeConfig));
    }

    @Override
    protected NormalizedNodeContainerBuilder createBuilder(NormalizedNode<?, ?> original) {
        if (original instanceof MapNode) {
            return ImmutableMapNodeBuilder.create((MapNode)original);
        }
        if (original instanceof MapEntryNode) {
            return ImmutableMapEntryNodeBuilder.create((MapEntryNode)original);
        }
        throw new IllegalArgumentException("MapModification strategy can only handle MapNode or MapEntryNode's, offending node: " + original);
    }

    @Override
    protected NormalizedNode<?, ?> createEmptyValue(NormalizedNode<?, ?> original) {
        if (original instanceof MapNode) {
            return ImmutableMapNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)((MapNode)original).getIdentifier()).build();
        }
        if (original instanceof MapEntryNode) {
            return ImmutableMapEntryNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((MapEntryNode)original).getIdentifier()).build();
        }
        throw new IllegalArgumentException("MapModification strategy can only handle MapNode or MapEntryNode's, offending node: " + original);
    }

    @Override
    public Optional<ModificationApplyOperation> getChild(YangInstanceIdentifier.PathArgument identifier) {
        if (identifier instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            return this.entryStrategy;
        }
        if (this.entryStrategy.isPresent()) {
            return this.entryStrategy.get().getChild(identifier);
        }
        return Optional.empty();
    }

    public String toString() {
        return "UnorderedMapModificationStrategy [entry=" + this.entryStrategy + "]";
    }
}

