/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.DatatypeConverter;
import org.opendaylight.yangtools.yang.data.api.codec.BinaryCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;

@Beta
public abstract class BinaryStringCodec
extends TypeDefinitionAwareCodec<byte[], BinaryTypeDefinition>
implements BinaryCodec<String> {
    BinaryStringCodec(BinaryTypeDefinition typeDef) {
        super(Optional.of(typeDef), byte[].class);
    }

    public static BinaryStringCodec from(BinaryTypeDefinition type) {
        Optional optConstraint = type.getLengthConstraint();
        return optConstraint.isPresent() ? new Restricted(type, (LengthConstraint)optConstraint.get()) : new Unrestricted(type);
    }

    @Override
    public String serialize(byte[] data) {
        return data == null ? "" : BaseEncoding.base64().encode(data);
    }

    @Override
    public byte[] deserialize(String stringRepresentation) {
        if (stringRepresentation == null) {
            return null;
        }
        byte[] ret = DatatypeConverter.parseBase64Binary((String)stringRepresentation);
        this.validate(ret);
        return ret;
    }

    abstract void validate(byte[] var1);

    private static final class Unrestricted
    extends BinaryStringCodec {
        Unrestricted(BinaryTypeDefinition typeDef) {
            super(typeDef);
        }

        @Override
        void validate(byte[] value) {
        }
    }

    private static final class Restricted
    extends BinaryStringCodec {
        private final LengthConstraint lengthConstraint;

        Restricted(BinaryTypeDefinition typeDef, LengthConstraint lengthConstraint) {
            super(typeDef);
            this.lengthConstraint = Objects.requireNonNull(lengthConstraint);
        }

        @Override
        void validate(byte[] value) {
            Preconditions.checkArgument((boolean)this.lengthConstraint.getAllowedRanges().contains((Comparable)Integer.valueOf(value.length)), (String)"Value length %s does not match constraint %s", (int)value.length, (Object)this.lengthConstraint);
        }
    }
}

