/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.PatternSyntaxException;
import org.opendaylight.yangtools.yang.data.impl.codec.CompiledPatternContext;
import org.opendaylight.yangtools.yang.data.impl.codec.StringStringCodec;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StringPatternCheckingCodec
extends StringStringCodec {
    private static final Logger LOG = LoggerFactory.getLogger(StringPatternCheckingCodec.class);
    private final Collection<CompiledPatternContext> patterns;

    StringPatternCheckingCodec(StringTypeDefinition typeDef) {
        super(typeDef);
        this.patterns = new ArrayList<CompiledPatternContext>(typeDef.getPatternConstraints().size());
        for (PatternConstraint yangPattern : typeDef.getPatternConstraints()) {
            try {
                this.patterns.add(new CompiledPatternContext(yangPattern));
            }
            catch (PatternSyntaxException e) {
                LOG.debug("Unable to compile {} pattern, excluding it from validation.", (Object)yangPattern, (Object)e);
            }
        }
    }

    @Override
    void validate(String str) {
        super.validate(str);
        for (CompiledPatternContext pattern : this.patterns) {
            pattern.validate(str);
        }
    }
}

