/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.leafref;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.impl.leafref.QNamePredicate;
import org.opendaylight.yangtools.yang.data.impl.leafref.QNameWithPredicate;

final class QNameWithPredicateImpl
implements Immutable,
Serializable,
QNameWithPredicate {
    private static final long serialVersionUID = 1L;
    private final List<QNamePredicate> qnamePredicates;
    private final QNameModule moduleQname;
    private final String localName;

    QNameWithPredicateImpl(QNameModule moduleQname, String localName, List<QNamePredicate> qnamePredicates) {
        this.moduleQname = moduleQname;
        this.localName = localName;
        this.qnamePredicates = ImmutableList.copyOf(qnamePredicates);
    }

    @Override
    public List<QNamePredicate> getQNamePredicates() {
        return this.qnamePredicates;
    }

    @Override
    public QNameModule getModuleQname() {
        return this.moduleQname;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public QName getQName() {
        return QName.create((QNameModule)this.moduleQname, (String)this.localName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QNameWithPredicateImpl)) {
            return false;
        }
        QNameWithPredicateImpl other = (QNameWithPredicateImpl)obj;
        return Objects.equals(this.localName, other.localName) && this.moduleQname.equals((Object)other.moduleQname);
    }

    public int hashCode() {
        int result = this.moduleQname != null ? this.moduleQname.hashCode() : 0;
        result = 31 * result + (this.localName != null ? this.localName.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.moduleQname != null) {
            sb.append('(').append(this.moduleQname.getNamespace());
            sb.append("?revision=").append(this.moduleQname.getRevision());
            sb.append(')');
        }
        sb.append(this.localName);
        for (QNamePredicate predicate : this.qnamePredicates) {
            sb.append(predicate);
        }
        return sb.toString();
    }
}

