/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.InstanceIdToNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.InstanceIdToSimpleNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.AttributesBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.ListNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.util.EffectiveAugmentationSchema;

abstract class InstanceIdToCompositeNodes<T extends YangInstanceIdentifier.PathArgument>
extends InstanceIdToNodes<T> {
    protected InstanceIdToCompositeNodes(T identifier) {
        super(identifier);
    }

    private static YangInstanceIdentifier.AugmentationIdentifier augmentationIdentifierFrom(AugmentationSchemaNode augmentation) {
        ImmutableSet.Builder potentialChildren = ImmutableSet.builder();
        for (DataSchemaNode child : augmentation.getChildNodes()) {
            potentialChildren.add((Object)child.getQName());
        }
        return new YangInstanceIdentifier.AugmentationIdentifier((Set)potentialChildren.build());
    }

    private static DataNodeContainer augmentationProxy(AugmentationSchemaNode augmentation, DataNodeContainer schema) {
        HashSet<DataSchemaNode> children = new HashSet<DataSchemaNode>();
        for (DataSchemaNode augNode : augmentation.getChildNodes()) {
            children.add(schema.getDataChildByName(augNode.getQName()));
        }
        return new EffectiveAugmentationSchema(augmentation, children);
    }

    @Override
    public final NormalizedNode<?, ?> create(YangInstanceIdentifier instanceId, Optional<NormalizedNode<?, ?>> lastChild, Optional<Map.Entry<QName, ModifyAction>> operation) {
        Preconditions.checkNotNull((Object)instanceId);
        Iterator iterator = instanceId.getPathArguments().iterator();
        YangInstanceIdentifier.PathArgument legacyData = (YangInstanceIdentifier.PathArgument)iterator.next();
        if (!this.isMixin() && ((InstanceIdToNodes)this).getIdentifier().getNodeType() != null) {
            Preconditions.checkArgument((boolean)((InstanceIdToNodes)this).getIdentifier().getNodeType().equals((Object)legacyData.getNodeType()), (String)"Node QName must be %s was %s", (Object)((InstanceIdToNodes)this).getIdentifier().getNodeType(), (Object)legacyData.getNodeType());
        }
        NormalizedNodeContainerBuilder<?, ?, ?, ?> builder = this.createBuilder(legacyData);
        if (iterator.hasNext()) {
            YangInstanceIdentifier.PathArgument childPath = (YangInstanceIdentifier.PathArgument)iterator.next();
            InstanceIdToNodes<?> childOp = this.getChildOperation(childPath);
            YangInstanceIdentifier childId = YangInstanceIdentifier.create((Iterable)Iterables.skip((Iterable)instanceId.getPathArguments(), (int)1));
            builder.addChild(childOp.create(childId, lastChild, operation));
        } else {
            if (lastChild.isPresent()) {
                builder.withValue((Collection<?>)ImmutableList.copyOf((Collection)((Collection)lastChild.get().getValue())));
            }
            if (operation.isPresent()) {
                Preconditions.checkArgument((boolean)(builder instanceof AttributesBuilder));
                this.addModifyOpIfPresent(operation, (AttributesBuilder)((Object)builder));
            }
        }
        return builder.build();
    }

    private InstanceIdToNodes<?> getChildOperation(YangInstanceIdentifier.PathArgument childPath) {
        InstanceIdToNodes<?> childOp;
        try {
            childOp = this.getChild(childPath);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(String.format("Failed to process child node %s", childPath), e);
        }
        Preconditions.checkArgument((childOp != null ? 1 : 0) != 0, (String)"Node %s is not allowed inside %s", (Object)childPath, ((InstanceIdToNodes)this).getIdentifier());
        return childOp;
    }

    protected abstract NormalizedNodeContainerBuilder<?, ?, ?, ?> createBuilder(YangInstanceIdentifier.PathArgument var1);

    static final class ChoiceNodeNormalization
    extends InstanceIdToCompositeNodes<YangInstanceIdentifier.NodeIdentifier> {
        private final ImmutableMap<YangInstanceIdentifier.PathArgument, InstanceIdToNodes<?>> byArg;

        ChoiceNodeNormalization(ChoiceSchemaNode schema) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()));
            ImmutableMap.Builder byArgBuilder = ImmutableMap.builder();
            for (CaseSchemaNode caze : schema.getCases().values()) {
                for (DataSchemaNode cazeChild : caze.getChildNodes()) {
                    InstanceIdToNodes<?> childOp = ChoiceNodeNormalization.fromDataSchemaNode(cazeChild);
                    byArgBuilder.put(childOp.getIdentifier(), childOp);
                }
            }
            this.byArg = byArgBuilder.build();
        }

        @Override
        public InstanceIdToNodes<?> getChild(YangInstanceIdentifier.PathArgument child) {
            return (InstanceIdToNodes)this.byArg.get((Object)child);
        }

        protected DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ChoiceNode> createBuilder(YangInstanceIdentifier.PathArgument compositeNode) {
            return Builders.choiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((InstanceIdToNodes)this).getIdentifier());
        }

        @Override
        boolean isMixin() {
            return true;
        }
    }

    static final class OrderedMapMixinNormalization
    extends UnorderedMapMixinNormalization {
        OrderedMapMixinNormalization(ListSchemaNode list) {
            super(list);
        }

        @Override
        protected CollectionNodeBuilder<MapEntryNode, OrderedMapNode> createBuilder(YangInstanceIdentifier.PathArgument compositeNode) {
            return Builders.orderedMapBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)((InstanceIdToNodes)this).getIdentifier());
        }
    }

    static class UnorderedMapMixinNormalization
    extends InstanceIdToCompositeNodes<YangInstanceIdentifier.NodeIdentifier> {
        private final ListItemNormalization innerNode;

        UnorderedMapMixinNormalization(ListSchemaNode list) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)list.getQName()));
            this.innerNode = new ListItemNormalization(new YangInstanceIdentifier.NodeIdentifierWithPredicates(list.getQName(), Collections.emptyMap()), list);
        }

        protected CollectionNodeBuilder<MapEntryNode, ? extends MapNode> createBuilder(YangInstanceIdentifier.PathArgument compositeNode) {
            return Builders.mapBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)((InstanceIdToNodes)this).getIdentifier());
        }

        @Override
        public InstanceIdToNodes<?> getChild(YangInstanceIdentifier.PathArgument child) {
            if (child.getNodeType().equals((Object)((YangInstanceIdentifier.NodeIdentifier)((InstanceIdToNodes)this).getIdentifier()).getNodeType())) {
                return this.innerNode;
            }
            return null;
        }

        @Override
        boolean isMixin() {
            return true;
        }
    }

    static final class AugmentationNormalization
    extends DataContainerNormalizationOperation<YangInstanceIdentifier.AugmentationIdentifier> {
        AugmentationNormalization(AugmentationSchemaNode augmentation, DataNodeContainer schema) {
            super(InstanceIdToCompositeNodes.augmentationIdentifierFrom(augmentation), InstanceIdToCompositeNodes.augmentationProxy(augmentation, schema));
        }

        protected DataContainerNodeBuilder<YangInstanceIdentifier.AugmentationIdentifier, AugmentationNode> createBuilder(YangInstanceIdentifier.PathArgument compositeNode) {
            return Builders.augmentationBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((InstanceIdToNodes)this).getIdentifier());
        }

        @Override
        boolean isMixin() {
            return true;
        }
    }

    static class UnorderedLeafListMixinNormalization
    extends InstanceIdToCompositeNodes<YangInstanceIdentifier.NodeIdentifier> {
        private final InstanceIdToNodes<?> innerOp;

        UnorderedLeafListMixinNormalization(LeafListSchemaNode potential) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)potential.getQName()));
            this.innerOp = new InstanceIdToSimpleNodes.LeafListEntryNormalization(potential);
        }

        protected ListNodeBuilder<?, ?> createBuilder(YangInstanceIdentifier.PathArgument compositeNode) {
            return Builders.leafSetBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)((InstanceIdToNodes)this).getIdentifier());
        }

        @Override
        public InstanceIdToNodes<?> getChild(YangInstanceIdentifier.PathArgument child) {
            if (child instanceof YangInstanceIdentifier.NodeWithValue) {
                return this.innerOp;
            }
            return null;
        }

        @Override
        boolean isMixin() {
            return true;
        }
    }

    static final class OrderedLeafListMixinNormalization
    extends UnorderedLeafListMixinNormalization {
        OrderedLeafListMixinNormalization(LeafListSchemaNode potential) {
            super(potential);
        }

        @Override
        protected ListNodeBuilder<?, ?> createBuilder(YangInstanceIdentifier.PathArgument compositeNode) {
            return Builders.orderedLeafSetBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)((InstanceIdToNodes)this).getIdentifier());
        }
    }

    static final class ContainerTransformation
    extends DataContainerNormalizationOperation<YangInstanceIdentifier.NodeIdentifier> {
        ContainerTransformation(ContainerSchemaNode schema) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()), (DataNodeContainer)schema);
        }

        protected DataContainerNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode> createBuilder(YangInstanceIdentifier.PathArgument compositeNode) {
            return Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((InstanceIdToNodes)this).getIdentifier());
        }

        @Override
        boolean isMixin() {
            return false;
        }
    }

    static final class UnkeyedListItemNormalization
    extends DataContainerNormalizationOperation<YangInstanceIdentifier.NodeIdentifier> {
        UnkeyedListItemNormalization(ListSchemaNode schema) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()), (DataNodeContainer)schema);
        }

        protected DataContainerNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifier, UnkeyedListEntryNode> createBuilder(YangInstanceIdentifier.PathArgument compositeNode) {
            return Builders.unkeyedListEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((InstanceIdToNodes)this).getIdentifier());
        }

        @Override
        boolean isMixin() {
            return false;
        }
    }

    static final class ListItemNormalization
    extends DataContainerNormalizationOperation<YangInstanceIdentifier.NodeIdentifierWithPredicates> {
        protected ListItemNormalization(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, ListSchemaNode schema) {
            super(identifier, (DataNodeContainer)schema);
        }

        protected DataContainerNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> createBuilder(YangInstanceIdentifier.PathArgument currentArg) {
            YangInstanceIdentifier.NodeIdentifierWithPredicates arg = (YangInstanceIdentifier.NodeIdentifierWithPredicates)currentArg;
            DataContainerNodeBuilder builder = Builders.mapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)arg);
            for (Map.Entry keyValue : arg.getKeyValues().entrySet()) {
                builder.addChild(Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)((QName)keyValue.getKey()))).withValue(keyValue.getValue()).build());
            }
            return builder;
        }

        @Override
        boolean isMixin() {
            return false;
        }
    }

    static abstract class DataContainerNormalizationOperation<T extends YangInstanceIdentifier.PathArgument>
    extends InstanceIdToCompositeNodes<T> {
        private final DataNodeContainer schema;
        private final Map<YangInstanceIdentifier.PathArgument, InstanceIdToNodes<?>> byArg;

        protected DataContainerNormalizationOperation(T identifier, DataNodeContainer schema) {
            super(identifier);
            this.schema = schema;
            this.byArg = new ConcurrentHashMap();
        }

        @Override
        public InstanceIdToNodes<?> getChild(YangInstanceIdentifier.PathArgument child) {
            InstanceIdToNodes<?> potential = this.byArg.get(child);
            if (potential != null) {
                return potential;
            }
            potential = this.fromLocalSchema(child);
            return this.register(potential);
        }

        private InstanceIdToNodes<?> fromLocalSchema(YangInstanceIdentifier.PathArgument child) {
            if (child instanceof YangInstanceIdentifier.AugmentationIdentifier) {
                return DataContainerNormalizationOperation.fromSchemaAndQNameChecked(this.schema, (QName)((YangInstanceIdentifier.AugmentationIdentifier)child).getPossibleChildNames().iterator().next());
            }
            return DataContainerNormalizationOperation.fromSchemaAndQNameChecked(this.schema, child.getNodeType());
        }

        private InstanceIdToNodes<?> register(InstanceIdToNodes<?> potential) {
            if (potential != null) {
                this.byArg.put((YangInstanceIdentifier.PathArgument)potential.getIdentifier(), potential);
            }
            return potential;
        }
    }
}

