/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.InstanceIdToCompositeNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.InstanceIdToSimpleNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.AttributesBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeBuilder;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

abstract class InstanceIdToNodes<T extends YangInstanceIdentifier.PathArgument>
implements Identifiable<T> {
    private final T identifier;

    public final T getIdentifier() {
        return this.identifier;
    }

    protected InstanceIdToNodes(T identifier) {
        this.identifier = identifier;
    }

    abstract InstanceIdToNodes<?> getChild(YangInstanceIdentifier.PathArgument var1);

    abstract NormalizedNode<?, ?> create(YangInstanceIdentifier var1, Optional<NormalizedNode<?, ?>> var2, Optional<Map.Entry<QName, ModifyAction>> var3);

    abstract boolean isMixin();

    public void addModifyOpIfPresent(Optional<Map.Entry<QName, ModifyAction>> operation, AttributesBuilder<?> builder) {
        if (operation.isPresent()) {
            builder.withAttributes(Collections.singletonMap(operation.get().getKey(), InstanceIdToNodes.modifyOperationToXmlString(operation.get().getValue())));
        }
    }

    public static String modifyOperationToXmlString(ModifyAction operation) {
        return operation.name().toLowerCase();
    }

    private static Optional<DataSchemaNode> findChildSchemaNode(DataNodeContainer parent, QName child) {
        DataSchemaNode potential = parent.getDataChildByName(child);
        if (potential == null) {
            potential = InstanceIdToNodes.findChoice(Iterables.filter((Iterable)parent.getChildNodes(), ChoiceSchemaNode.class), child);
        }
        return Optional.ofNullable(potential);
    }

    static InstanceIdToNodes<?> fromSchemaAndQNameChecked(DataNodeContainer schema, QName child) {
        Optional<DataSchemaNode> potential = InstanceIdToNodes.findChildSchemaNode(schema, child);
        Preconditions.checkArgument((boolean)potential.isPresent(), (String)"Supplied QName %s is not valid according to schema %s, potential children nodes: %s", (Object)child, (Object)schema, (Object)schema.getChildNodes());
        DataSchemaNode result = potential.get();
        if (schema instanceof DataSchemaNode && result.isAugmenting()) {
            return InstanceIdToNodes.fromAugmentation(schema, (AugmentationTarget)schema, result);
        }
        return InstanceIdToNodes.fromDataSchemaNode(result);
    }

    private static ChoiceSchemaNode findChoice(Iterable<ChoiceSchemaNode> choices, QName child) {
        ChoiceSchemaNode foundChoice = null;
        block0: for (ChoiceSchemaNode choice : choices) {
            for (CaseSchemaNode caze : choice.getCases().values()) {
                if (!InstanceIdToNodes.findChildSchemaNode((DataNodeContainer)caze, child).isPresent()) continue;
                foundChoice = choice;
                break block0;
            }
        }
        return foundChoice;
    }

    private static InstanceIdToNodes<?> fromAugmentation(DataNodeContainer parent, AugmentationTarget parentAug, DataSchemaNode child) {
        AugmentationSchemaNode augmentation = null;
        for (AugmentationSchemaNode aug : parentAug.getAvailableAugmentations()) {
            DataSchemaNode potential = aug.getDataChildByName(child.getQName());
            if (potential == null) continue;
            augmentation = aug;
            break;
        }
        if (augmentation != null) {
            return new InstanceIdToCompositeNodes.AugmentationNormalization(augmentation, parent);
        }
        return InstanceIdToNodes.fromDataSchemaNode(child);
    }

    static InstanceIdToNodes<?> fromDataSchemaNode(DataSchemaNode potential) {
        if (potential instanceof ContainerSchemaNode) {
            return new InstanceIdToCompositeNodes.ContainerTransformation((ContainerSchemaNode)potential);
        }
        if (potential instanceof ListSchemaNode) {
            return InstanceIdToNodes.fromListSchemaNode((ListSchemaNode)potential);
        }
        if (potential instanceof LeafSchemaNode) {
            return new InstanceIdToSimpleNodes.LeafNormalization((LeafSchemaNode)potential);
        }
        if (potential instanceof ChoiceSchemaNode) {
            return new InstanceIdToCompositeNodes.ChoiceNodeNormalization((ChoiceSchemaNode)potential);
        }
        if (potential instanceof LeafListSchemaNode) {
            return InstanceIdToNodes.fromLeafListSchemaNode((LeafListSchemaNode)potential);
        }
        if (potential instanceof AnyXmlSchemaNode) {
            return new AnyXmlNormalization((AnyXmlSchemaNode)potential);
        }
        return null;
    }

    private static InstanceIdToNodes<?> fromListSchemaNode(ListSchemaNode potential) {
        List keyDefinition = potential.getKeyDefinition();
        if (keyDefinition == null || keyDefinition.isEmpty()) {
            return new UnkeyedListMixinNormalization(potential);
        }
        if (potential.isUserOrdered()) {
            return new InstanceIdToCompositeNodes.OrderedMapMixinNormalization(potential);
        }
        return new InstanceIdToCompositeNodes.UnorderedMapMixinNormalization(potential);
    }

    private static InstanceIdToNodes<?> fromLeafListSchemaNode(LeafListSchemaNode potential) {
        if (potential.isUserOrdered()) {
            return new InstanceIdToCompositeNodes.OrderedLeafListMixinNormalization(potential);
        }
        return new InstanceIdToCompositeNodes.UnorderedLeafListMixinNormalization(potential);
    }

    private static class AnyXmlNormalization
    extends InstanceIdToNodes<YangInstanceIdentifier.NodeIdentifier> {
        AnyXmlNormalization(AnyXmlSchemaNode schema) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()));
        }

        @Override
        public InstanceIdToNodes<?> getChild(YangInstanceIdentifier.PathArgument child) {
            return null;
        }

        @Override
        public NormalizedNode<?, ?> create(YangInstanceIdentifier instanceId, Optional<NormalizedNode<?, ?>> deepestChild, Optional<Map.Entry<QName, ModifyAction>> operation) {
            if (deepestChild.isPresent()) {
                NormalizedNode<?, ?> child = deepestChild.get();
                Preconditions.checkState((boolean)(child instanceof AnyXmlNode));
                NormalizedNodeBuilder anyXmlBuilder = Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((InstanceIdToNodes)this).getIdentifier()).withValue(((AnyXmlNode)child).getValue());
                this.addModifyOpIfPresent(operation, (AttributesBuilder<?>)((Object)anyXmlBuilder));
                return anyXmlBuilder.build();
            }
            NormalizedNodeBuilder builder = Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((InstanceIdToNodes)this).getIdentifier());
            this.addModifyOpIfPresent(operation, (AttributesBuilder<?>)((Object)builder));
            return builder.build();
        }

        @Override
        boolean isMixin() {
            return false;
        }
    }

    private static final class UnkeyedListMixinNormalization
    extends InstanceIdToCompositeNodes<YangInstanceIdentifier.NodeIdentifier> {
        private final InstanceIdToCompositeNodes.UnkeyedListItemNormalization innerNode;

        UnkeyedListMixinNormalization(ListSchemaNode list) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)list.getQName()));
            this.innerNode = new InstanceIdToCompositeNodes.UnkeyedListItemNormalization(list);
        }

        protected CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> createBuilder(YangInstanceIdentifier.PathArgument compositeNode) {
            return Builders.unkeyedListBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)((InstanceIdToNodes)this).getIdentifier());
        }

        @Override
        public InstanceIdToNodes<?> getChild(YangInstanceIdentifier.PathArgument child) {
            if (child.getNodeType().equals((Object)((YangInstanceIdentifier.NodeIdentifier)((InstanceIdToNodes)this).getIdentifier()).getNodeType())) {
                return this.innerNode;
            }
            return null;
        }

        @Override
        boolean isMixin() {
            return true;
        }
    }
}

