/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.valid.DataNodeContainerValidator;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;

public final class ImmutableContainerNodeSchemaAwareBuilder
extends ImmutableContainerNodeBuilder {
    private final DataNodeContainerValidator validator;

    private ImmutableContainerNodeSchemaAwareBuilder(ContainerSchemaNode schema) {
        this.validator = new DataNodeContainerValidator((DataNodeContainer)schema);
        super.withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()));
    }

    private ImmutableContainerNodeSchemaAwareBuilder(ContainerSchemaNode schema, ImmutableContainerNodeBuilder.ImmutableContainerNode node) {
        super(node);
        this.validator = new DataNodeContainerValidator((DataNodeContainer)schema);
        super.withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()));
    }

    public static DataContainerNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode> create(ContainerSchemaNode schema) {
        return new ImmutableContainerNodeSchemaAwareBuilder(schema);
    }

    public static DataContainerNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode> create(ContainerSchemaNode schema, ContainerNode node) {
        if (!(node instanceof ImmutableContainerNodeBuilder.ImmutableContainerNode)) {
            throw new UnsupportedOperationException(String.format("Cannot initialize from class %s", node.getClass()));
        }
        return new ImmutableContainerNodeSchemaAwareBuilder(schema, (ImmutableContainerNodeBuilder.ImmutableContainerNode)node);
    }

    @Override
    public DataContainerNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode> withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        throw new UnsupportedOperationException("Node identifier created from schema");
    }

    @Override
    public DataContainerNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode> withChild(DataContainerChild<?, ?> child) {
        this.validator.validateChild(child.getIdentifier());
        return super.withChild((DataContainerChild)child);
    }

    @Override
    public ContainerNode build() {
        return super.build();
    }
}

