/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import java.util.Map;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.AbstractImmutableNormalizedNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.AbstractImmutableNormalizedValueAttrNode;

public class ImmutableLeafNodeBuilder<T>
extends AbstractImmutableNormalizedNodeBuilder<YangInstanceIdentifier.NodeIdentifier, T, LeafNode<T>> {
    public static <T> NormalizedNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifier, T, LeafNode<T>> create() {
        return new ImmutableLeafNodeBuilder<T>();
    }

    @Override
    public LeafNode<T> build() {
        Object value = this.getValue();
        if (value instanceof byte[]) {
            return new ImmutableBinaryLeafNode((YangInstanceIdentifier.NodeIdentifier)this.getNodeIdentifier(), (byte[])value, this.getAttributes());
        }
        return new ImmutableLeafNode((YangInstanceIdentifier.NodeIdentifier)this.getNodeIdentifier(), value, this.getAttributes());
    }

    private static final class ImmutableBinaryLeafNode
    extends AbstractImmutableNormalizedValueAttrNode<YangInstanceIdentifier.NodeIdentifier, byte[]>
    implements LeafNode<byte[]> {
        ImmutableBinaryLeafNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, byte[] value, Map<QName, String> attributes) {
            super(nodeIdentifier, value, attributes);
        }

        @Override
        protected byte[] wrapValue(byte[] valueToWrap) {
            return (byte[])valueToWrap.clone();
        }
    }

    private static final class ImmutableLeafNode<T>
    extends AbstractImmutableNormalizedValueAttrNode<YangInstanceIdentifier.NodeIdentifier, T>
    implements LeafNode<T> {
        ImmutableLeafNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, T value, Map<QName, String> attributes) {
            super(nodeIdentifier, value, attributes);
        }
    }
}

