/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.util.UnmodifiableCollection;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedMapNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.AbstractImmutableNormalizedNode;

public class ImmutableOrderedMapNodeBuilder
implements CollectionNodeBuilder<MapEntryNode, OrderedMapNode> {
    private static final int DEFAULT_CAPACITY = 4;
    private Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> value;
    private YangInstanceIdentifier.NodeIdentifier nodeIdentifier;
    private boolean dirty;

    protected ImmutableOrderedMapNodeBuilder() {
        this.value = new LinkedHashMap<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>(4);
        this.dirty = false;
    }

    protected ImmutableOrderedMapNodeBuilder(int sizeHint) {
        this.value = sizeHint >= 0 ? new LinkedHashMap<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>(sizeHint + sizeHint / 3) : new LinkedHashMap<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>(4);
        this.dirty = false;
    }

    protected ImmutableOrderedMapNodeBuilder(ImmutableOrderedMapNode node) {
        this.nodeIdentifier = (YangInstanceIdentifier.NodeIdentifier)node.getIdentifier();
        this.value = node.children;
        this.dirty = true;
    }

    public static CollectionNodeBuilder<MapEntryNode, OrderedMapNode> create() {
        return new ImmutableOrderedMapNodeBuilder();
    }

    public static CollectionNodeBuilder<MapEntryNode, OrderedMapNode> create(int sizeHint) {
        return new ImmutableOrderedMapNodeBuilder(sizeHint);
    }

    public static CollectionNodeBuilder<MapEntryNode, OrderedMapNode> create(MapNode node) {
        if (!(node instanceof ImmutableOrderedMapNode)) {
            throw new UnsupportedOperationException(String.format("Cannot initialize from class %s", node.getClass()));
        }
        return new ImmutableOrderedMapNodeBuilder((ImmutableOrderedMapNode)node);
    }

    private void checkDirty() {
        if (this.dirty) {
            this.value = new LinkedHashMap<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>(this.value);
            this.dirty = false;
        }
    }

    @Override
    public CollectionNodeBuilder<MapEntryNode, OrderedMapNode> withChild(MapEntryNode child) {
        this.checkDirty();
        this.value.put(child.getIdentifier(), child);
        return this;
    }

    @Override
    public CollectionNodeBuilder<MapEntryNode, OrderedMapNode> withoutChild(YangInstanceIdentifier.PathArgument key) {
        this.checkDirty();
        this.value.remove(key);
        return this;
    }

    @Override
    public CollectionNodeBuilder<MapEntryNode, OrderedMapNode> withValue(Collection<MapEntryNode> withValue) {
        for (MapEntryNode mapEntryNode : withValue) {
            this.withChild(mapEntryNode);
        }
        return this;
    }

    @Override
    public CollectionNodeBuilder<MapEntryNode, OrderedMapNode> withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        this.nodeIdentifier = withNodeIdentifier;
        return this;
    }

    @Override
    public OrderedMapNode build() {
        this.dirty = true;
        return new ImmutableOrderedMapNode(this.nodeIdentifier, this.value);
    }

    public CollectionNodeBuilder<MapEntryNode, OrderedMapNode> addChild(MapEntryNode child) {
        return this.withChild(child);
    }

    @Override
    public NormalizedNodeContainerBuilder<YangInstanceIdentifier.NodeIdentifier, YangInstanceIdentifier.PathArgument, MapEntryNode, OrderedMapNode> removeChild(YangInstanceIdentifier.PathArgument key) {
        return this.withoutChild(key);
    }

    protected static final class ImmutableOrderedMapNode
    extends AbstractImmutableNormalizedNode<YangInstanceIdentifier.NodeIdentifier, Collection<MapEntryNode>>
    implements Immutable,
    OrderedMapNode {
        private final Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> children;

        ImmutableOrderedMapNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> children) {
            super(nodeIdentifier);
            this.children = children;
        }

        public Optional<MapEntryNode> getChild(YangInstanceIdentifier.NodeIdentifierWithPredicates child) {
            return Optional.ofNullable(this.children.get(child));
        }

        public MapEntryNode getChild(int position) {
            return (MapEntryNode)Iterables.get(this.children.values(), (int)position);
        }

        @Override
        protected int valueHashCode() {
            return this.children.hashCode();
        }

        @Override
        protected boolean valueEquals(AbstractImmutableNormalizedNode<?, ?> other) {
            return this.children.equals(((ImmutableOrderedMapNode)other).children);
        }

        public int getSize() {
            return this.children.size();
        }

        public Collection<MapEntryNode> getValue() {
            return UnmodifiableCollection.create(this.children.values());
        }
    }
}

