/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.valid;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.impl.schema.SchemaUtils;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.valid.DataValidationException;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

public class DataNodeContainerValidator {
    private final Set<YangInstanceIdentifier.AugmentationIdentifier> augments = new HashSet<YangInstanceIdentifier.AugmentationIdentifier>();
    private final DataNodeContainer schema;
    private final Set<QName> childNodes;

    public DataNodeContainerValidator(DataNodeContainer schema) {
        this.schema = (DataNodeContainer)Preconditions.checkNotNull((Object)schema, (Object)"Schema was null");
        this.childNodes = DataNodeContainerValidator.getChildNodes(schema);
        if (schema instanceof AugmentationTarget) {
            for (AugmentationSchemaNode augmentation : ((AugmentationTarget)schema).getAvailableAugmentations()) {
                this.augments.add(SchemaUtils.getNodeIdentifierForAugmentation(augmentation));
            }
        }
    }

    private boolean isKnownChild(YangInstanceIdentifier.PathArgument child) {
        if (child instanceof YangInstanceIdentifier.AugmentationIdentifier) {
            return this.augments.contains(child);
        }
        return this.childNodes.contains(child.getNodeType());
    }

    public void validateChild(YangInstanceIdentifier.PathArgument child) {
        DataValidationException.checkLegalChild(this.isKnownChild(child), child, this.schema, this.childNodes, this.augments);
    }

    public DataContainerChild<?, ?> validateChild(DataContainerChild<?, ?> child) {
        this.validateChild(child.getIdentifier());
        return child;
    }

    private static Set<QName> getChildNodes(DataNodeContainer nodeContainer) {
        HashSet<QName> allChildNodes = new HashSet<QName>();
        for (DataSchemaNode childSchema : nodeContainer.getChildNodes()) {
            if (childSchema instanceof CaseSchemaNode) {
                allChildNodes.addAll(DataNodeContainerValidator.getChildNodes((DataNodeContainer)childSchema));
                continue;
            }
            if (childSchema instanceof AugmentationSchemaNode) continue;
            allChildNodes.add(childSchema.getQName());
        }
        return allChildNodes;
    }
}

