/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.nodes;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public abstract class AbstractImmutableNormalizedNode<K extends YangInstanceIdentifier.PathArgument, V>
implements NormalizedNode<K, V>,
Immutable {
    private final K nodeIdentifier;

    protected AbstractImmutableNormalizedNode(K nodeIdentifier) {
        this.nodeIdentifier = (YangInstanceIdentifier.PathArgument)Preconditions.checkNotNull(nodeIdentifier, (Object)"nodeIdentifier");
    }

    public final QName getNodeType() {
        return this.getIdentifier().getNodeType();
    }

    public final K getIdentifier() {
        return this.nodeIdentifier;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("nodeIdentifier", this.nodeIdentifier).add("value", this.getValue());
    }

    protected abstract boolean valueEquals(AbstractImmutableNormalizedNode<?, ?> var1);

    protected abstract int valueHashCode();

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractImmutableNormalizedNode other = (AbstractImmutableNormalizedNode)obj;
        if (!this.nodeIdentifier.equals(other.nodeIdentifier)) {
            return false;
        }
        return this.valueEquals(other);
    }

    public final int hashCode() {
        int result = this.nodeIdentifier.hashCode();
        result = 31 * result + this.valueHashCode();
        return result;
    }
}

