/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDataNodeContainerModificationStrategy<T extends DataNodeContainer>
extends AbstractNodeContainerModificationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDataNodeContainerModificationStrategy.class);
    private final LoadingCache<YangInstanceIdentifier.PathArgument, ModificationApplyOperation> childCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<YangInstanceIdentifier.PathArgument, ModificationApplyOperation>(){

        public ModificationApplyOperation load(@Nonnull YangInstanceIdentifier.PathArgument key) {
            if (key instanceof YangInstanceIdentifier.AugmentationIdentifier && AbstractDataNodeContainerModificationStrategy.this.schema instanceof AugmentationTarget) {
                return SchemaAwareApplyOperation.from(AbstractDataNodeContainerModificationStrategy.this.schema, (AugmentationTarget)AbstractDataNodeContainerModificationStrategy.this.schema, (YangInstanceIdentifier.AugmentationIdentifier)key, AbstractDataNodeContainerModificationStrategy.this.treeConfig);
            }
            DataSchemaNode child = AbstractDataNodeContainerModificationStrategy.this.schema.getDataChildByName(key.getNodeType());
            Preconditions.checkArgument((child != null ? 1 : 0) != 0, (String)"Schema %s does not have a node for child %s", (Object)AbstractDataNodeContainerModificationStrategy.this.schema, (Object)key.getNodeType());
            return SchemaAwareApplyOperation.from(child, AbstractDataNodeContainerModificationStrategy.this.treeConfig);
        }
    });
    private final T schema;
    private final DataTreeConfiguration treeConfig;

    protected AbstractDataNodeContainerModificationStrategy(T schema, Class<? extends NormalizedNode<?, ?>> nodeClass, DataTreeConfiguration treeConfig) {
        super(nodeClass, treeConfig);
        this.schema = (DataNodeContainer)Objects.requireNonNull(schema, "schema");
        this.treeConfig = Objects.requireNonNull(treeConfig, "treeConfig");
    }

    protected final T getSchema() {
        return this.schema;
    }

    @Override
    public final Optional<ModificationApplyOperation> getChild(YangInstanceIdentifier.PathArgument identifier) {
        try {
            return Optional.ofNullable(this.childCache.get((Object)identifier));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            LOG.trace("Child {} not present in container schema {} children {}", new Object[]{identifier, this, this.schema.getChildNodes(), e});
            return Optional.empty();
        }
    }

    @Override
    protected abstract DataContainerNodeBuilder createBuilder(NormalizedNode<?, ?> var1);

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.schema + "]";
    }
}

