/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractRecursiveCandidateNode;

abstract class AbstractDataTreeCandidateNode
implements DataTreeCandidateNode {
    private final NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> data;

    private static Optional<NormalizedNode<?, ?>> getChild(NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> container, YangInstanceIdentifier.PathArgument identifier) {
        return container == null ? Optional.empty() : container.getChild(identifier);
    }

    static DataTreeCandidateNode deltaChild(NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> oldData, NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> newData, YangInstanceIdentifier.PathArgument identifier) {
        Optional<NormalizedNode<?, ?>> maybeNewChild = AbstractDataTreeCandidateNode.getChild(newData, identifier);
        Optional<NormalizedNode<?, ?>> maybeOldChild = AbstractDataTreeCandidateNode.getChild(oldData, identifier);
        if (maybeOldChild.isPresent()) {
            NormalizedNode<?, ?> oldChild = maybeOldChild.get();
            if (maybeNewChild.isPresent()) {
                return AbstractRecursiveCandidateNode.replaceNode(oldChild, maybeNewChild.get());
            }
            return AbstractRecursiveCandidateNode.deleteNode(oldChild);
        }
        return maybeNewChild.isPresent() ? AbstractRecursiveCandidateNode.writeNode(maybeNewChild.get()) : null;
    }

    static Collection<DataTreeCandidateNode> deltaChildren(@Nullable NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> oldData, @Nullable NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> newData) {
        Preconditions.checkArgument((newData != null || oldData != null ? 1 : 0) != 0, (Object)"No old or new data, modification type should be NONE and deltaChildren() mustn't be called.");
        if (newData == null) {
            return Collections2.transform((Collection)oldData.getValue(), AbstractRecursiveCandidateNode::deleteNode);
        }
        if (oldData == null) {
            return Collections2.transform((Collection)newData.getValue(), AbstractRecursiveCandidateNode::writeNode);
        }
        ArrayList<DataTreeCandidateNode> result = new ArrayList<DataTreeCandidateNode>();
        for (NormalizedNode child : newData.getValue()) {
            Optional maybeOldChild = oldData.getChild(child.getIdentifier());
            DataTreeCandidateNode node = maybeOldChild.isPresent() ? AbstractRecursiveCandidateNode.replaceNode((NormalizedNode)maybeOldChild.get(), child) : AbstractRecursiveCandidateNode.writeNode(child);
            result.add(node);
        }
        for (NormalizedNode child : oldData.getValue()) {
            if (newData.getChild(child.getIdentifier()).isPresent()) continue;
            result.add(AbstractRecursiveCandidateNode.deleteNode(child));
        }
        return result;
    }

    protected AbstractDataTreeCandidateNode(NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> data) {
        this.data = (NormalizedNodeContainer)Preconditions.checkNotNull(data);
    }

    protected final Optional<NormalizedNode<?, ?>> dataOptional() {
        return Optional.of(this.data);
    }

    @Nonnull
    public final YangInstanceIdentifier.PathArgument getIdentifier() {
        return this.data.getIdentifier();
    }

    protected final NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> getData() {
        return this.data;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{data = " + this.data + "}";
    }
}

