/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableAugmentationNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractDataNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.util.EffectiveAugmentationSchema;

final class AugmentationModificationStrategy
extends AbstractDataNodeContainerModificationStrategy<AugmentationSchemaNode> {
    AugmentationModificationStrategy(AugmentationSchemaNode schema, DataNodeContainer resolved, DataTreeConfiguration treeConfig) {
        super(AugmentationModificationStrategy.createAugmentProxy(schema, resolved), AugmentationNode.class, treeConfig);
    }

    @Override
    protected DataContainerNodeBuilder createBuilder(NormalizedNode<?, ?> original) {
        Preconditions.checkArgument((boolean)(original instanceof AugmentationNode));
        return ImmutableAugmentationNodeBuilder.create((AugmentationNode)original);
    }

    @Override
    protected NormalizedNode<?, ?> createEmptyValue(NormalizedNode<?, ?> original) {
        Preconditions.checkArgument((boolean)(original instanceof AugmentationNode));
        return ImmutableAugmentationNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((AugmentationNode)original).getIdentifier()).build();
    }

    private static AugmentationSchemaNode createAugmentProxy(AugmentationSchemaNode schema, DataNodeContainer resolved) {
        HashSet<DataSchemaNode> realChildSchemas = new HashSet<DataSchemaNode>();
        for (DataSchemaNode augChild : schema.getChildNodes()) {
            realChildSchemas.add(resolved.getDataChildByName(augChild.getQName()));
        }
        return new EffectiveAugmentationSchema(schema, realChildSchemas);
    }
}

