/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.TreeType;
import org.opendaylight.yangtools.yang.data.impl.schema.SchemaUtils;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.MandatoryLeafEnforcer;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

final class CaseEnforcer
implements Immutable {
    private final Map<YangInstanceIdentifier.NodeIdentifier, DataSchemaNode> children;
    private final Map<YangInstanceIdentifier.AugmentationIdentifier, AugmentationSchemaNode> augmentations;
    private final MandatoryLeafEnforcer enforcer;

    private CaseEnforcer(Map<YangInstanceIdentifier.NodeIdentifier, DataSchemaNode> children, Map<YangInstanceIdentifier.AugmentationIdentifier, AugmentationSchemaNode> augmentations, MandatoryLeafEnforcer enforcer) {
        this.children = (Map)Preconditions.checkNotNull(children);
        this.augmentations = (Map)Preconditions.checkNotNull(augmentations);
        this.enforcer = (MandatoryLeafEnforcer)Preconditions.checkNotNull((Object)enforcer);
    }

    static CaseEnforcer forTree(CaseSchemaNode schema, DataTreeConfiguration treeConfig) {
        TreeType type = treeConfig.getTreeType();
        ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
        ImmutableMap.Builder augmentationsBuilder = ImmutableMap.builder();
        if (SchemaAwareApplyOperation.belongsToTree(type, (DataSchemaNode)schema)) {
            for (DataSchemaNode child2 : schema.getChildNodes()) {
                if (!SchemaAwareApplyOperation.belongsToTree(type, child2)) continue;
                childrenBuilder.put((Object)YangInstanceIdentifier.NodeIdentifier.create((QName)child2.getQName()), (Object)child2);
            }
            for (AugmentationSchemaNode augment : schema.getAvailableAugmentations()) {
                if (!augment.getChildNodes().stream().anyMatch(child -> SchemaAwareApplyOperation.belongsToTree(type, child))) continue;
                augmentationsBuilder.put((Object)SchemaUtils.getNodeIdentifierForAugmentation(augment), (Object)augment);
            }
        }
        ImmutableMap children = childrenBuilder.build();
        ImmutableMap augmentations = augmentationsBuilder.build();
        return children.isEmpty() ? null : new CaseEnforcer((Map<YangInstanceIdentifier.NodeIdentifier, DataSchemaNode>)children, (Map<YangInstanceIdentifier.AugmentationIdentifier, AugmentationSchemaNode>)augmentations, MandatoryLeafEnforcer.forContainer((DataNodeContainer)schema, treeConfig));
    }

    Set<Map.Entry<YangInstanceIdentifier.NodeIdentifier, DataSchemaNode>> getChildEntries() {
        return this.children.entrySet();
    }

    Set<YangInstanceIdentifier.NodeIdentifier> getChildIdentifiers() {
        return this.children.keySet();
    }

    Set<Map.Entry<YangInstanceIdentifier.AugmentationIdentifier, AugmentationSchemaNode>> getAugmentationEntries() {
        return this.augmentations.entrySet();
    }

    Set<YangInstanceIdentifier.AugmentationIdentifier> getAugmentationIdentifiers() {
        return this.augmentations.keySet();
    }

    Set<YangInstanceIdentifier.PathArgument> getAllChildIdentifiers() {
        return Sets.union(this.children.keySet(), this.augmentations.keySet());
    }

    void enforceOnTreeNode(NormalizedNode<?, ?> normalizedNode) {
        this.enforcer.enforceOnData(normalizedNode);
    }
}

