/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractDataTreeTip;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.DataTreeState;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.NoopDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InMemoryDataTree
extends AbstractDataTreeTip
implements DataTree {
    private static final AtomicReferenceFieldUpdater<InMemoryDataTree, DataTreeState> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(InMemoryDataTree.class, DataTreeState.class, "state");
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDataTree.class);
    private final DataTreeConfiguration treeConfig;
    private final boolean maskMandatory;
    private volatile DataTreeState state;

    InMemoryDataTree(TreeNode rootNode, DataTreeConfiguration treeConfig, SchemaContext schemaContext) {
        this.treeConfig = (DataTreeConfiguration)Preconditions.checkNotNull((Object)treeConfig, (Object)"treeConfig");
        this.maskMandatory = true;
        this.state = DataTreeState.createInitial(rootNode);
        if (schemaContext != null) {
            this.setSchemaContext(schemaContext);
        }
    }

    InMemoryDataTree(TreeNode rootNode, DataTreeConfiguration treeConfig, SchemaContext schemaContext, DataSchemaNode rootSchemaNode, boolean maskMandatory) {
        this.treeConfig = (DataTreeConfiguration)Preconditions.checkNotNull((Object)treeConfig, (Object)"treeConfig");
        this.maskMandatory = maskMandatory;
        this.state = DataTreeState.createInitial(rootNode).withSchemaContext(schemaContext, this.getOperation(rootSchemaNode));
    }

    private ModificationApplyOperation getOperation(DataSchemaNode rootSchemaNode) {
        if (this.maskMandatory && rootSchemaNode instanceof ContainerSchemaNode) {
            return new ContainerModificationStrategy((ContainerSchemaNode)rootSchemaNode, this.treeConfig);
        }
        return SchemaAwareApplyOperation.from(rootSchemaNode, this.treeConfig);
    }

    public synchronized void setSchemaContext(SchemaContext newSchemaContext) {
        DataTreeState newState;
        DataTreeState currentState;
        Preconditions.checkNotNull((Object)newSchemaContext);
        LOG.debug("Following schema contexts will be attempted {}", (Object)newSchemaContext);
        DataSchemaContextTree contextTree = DataSchemaContextTree.from((SchemaContext)newSchemaContext);
        DataSchemaContextNode rootContextNode = contextTree.getChild(this.getRootPath());
        if (rootContextNode == null) {
            LOG.warn("Could not find root {} in new schema context, not upgrading", (Object)this.getRootPath());
            return;
        }
        DataSchemaNode rootSchemaNode = rootContextNode.getDataSchemaNode();
        if (!(rootSchemaNode instanceof DataNodeContainer)) {
            LOG.warn("Root {} resolves to non-container type {}, not upgrading", (Object)this.getRootPath(), (Object)rootSchemaNode);
            return;
        }
        ModificationApplyOperation rootNode = this.getOperation(rootSchemaNode);
        while (!STATE_UPDATER.compareAndSet(this, currentState = this.state, newState = currentState.withSchemaContext(newSchemaContext, rootNode))) {
        }
    }

    public InMemoryDataTreeSnapshot takeSnapshot() {
        return this.state.newSnapshot();
    }

    public void commit(DataTreeCandidate candidate) {
        DataTreeState newState;
        DataTreeState currentState;
        if (candidate instanceof NoopDataTreeCandidate) {
            return;
        }
        Preconditions.checkArgument((boolean)(candidate instanceof InMemoryDataTreeCandidate), (String)"Invalid candidate class %s", candidate.getClass());
        InMemoryDataTreeCandidate c = (InMemoryDataTreeCandidate)candidate;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Data Tree is {}", (Object)NormalizedNodes.toStringTree((NormalizedNode)c.getTipRoot().getData()));
        }
        TreeNode newRoot = c.getTipRoot();
        do {
            currentState = this.state;
            TreeNode currentRoot = currentState.getRoot();
            LOG.debug("Updating datastore from {} to {}", (Object)currentRoot, (Object)newRoot);
            TreeNode oldRoot = c.getBeforeRoot();
            if (oldRoot != currentRoot) {
                String oldStr = InMemoryDataTree.simpleToString(oldRoot);
                String currentStr = InMemoryDataTree.simpleToString(currentRoot);
                throw new IllegalStateException("Store tree " + currentStr + " and candidate base " + oldStr + " differ.");
            }
            newState = currentState.withRoot(newRoot);
            LOG.trace("Updated state from {} to {}", (Object)currentState, (Object)newState);
        } while (!STATE_UPDATER.compareAndSet(this, currentState, newState));
    }

    private static String simpleToString(Object obj) {
        return obj.getClass().getName() + "@" + Integer.toHexString(obj.hashCode());
    }

    @Override
    public YangInstanceIdentifier getRootPath() {
        return this.treeConfig.getRootPath();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("object", (Object)super.toString()).add("config", (Object)this.treeConfig).add("state", (Object)this.state).toString();
    }

    @Override
    @Nonnull
    protected TreeNode getTipRoot() {
        return this.state.getRoot();
    }
}

