/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractModifiedNodeBasedCandidateNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;

final class InMemoryDataTreeCandidate
extends AbstractDataTreeCandidate {
    private final RootNode root;

    InMemoryDataTreeCandidate(YangInstanceIdentifier rootPath, ModifiedNode modificationRoot, TreeNode beforeRoot, TreeNode afterRoot) {
        super(rootPath);
        this.root = new RootNode(modificationRoot, beforeRoot, afterRoot);
    }

    @Override
    @Nonnull
    protected TreeNode getTipRoot() {
        return this.root.getNewMeta();
    }

    TreeNode getBeforeRoot() {
        return this.root.getOldMeta();
    }

    public DataTreeCandidateNode getRootNode() {
        return this.root;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rootPath", (Object)this.getRootPath()).add("rootNode", (Object)this.getRootNode()).toString();
    }

    private static final class RootNode
    extends AbstractModifiedNodeBasedCandidateNode {
        RootNode(ModifiedNode mod, TreeNode oldMeta, TreeNode newMeta) {
            super(mod, oldMeta, newMeta);
        }

        @Nonnull
        public YangInstanceIdentifier.PathArgument getIdentifier() {
            throw new IllegalStateException("Attempted to get identifier of the root node");
        }
    }
}

