/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractCursor;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeModification;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.OperationWithModification;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.SchemaValidationFailedException;

final class InMemoryDataTreeModificationCursor
extends AbstractCursor<InMemoryDataTreeModification>
implements DataTreeModificationCursor {
    private final Deque<OperationWithModification> stack = new ArrayDeque<OperationWithModification>();

    InMemoryDataTreeModificationCursor(InMemoryDataTreeModification parent, YangInstanceIdentifier rootPath, OperationWithModification rootOp) {
        super(parent, rootPath);
        this.stack.push(rootOp);
    }

    private OperationWithModification resolveChildModification(YangInstanceIdentifier.PathArgument child) {
        ((InMemoryDataTreeModification)this.getParent()).upgradeIfPossible();
        OperationWithModification op = this.stack.peek();
        Optional<ModificationApplyOperation> potential = op.getApplyOperation().getChild(child);
        if (potential.isPresent()) {
            ModificationApplyOperation operation = potential.get();
            ModifiedNode modification = op.getModification().modifyChild(child, operation, ((InMemoryDataTreeModification)this.getParent()).getVersion());
            return OperationWithModification.from(operation, modification);
        }
        ArrayList<YangInstanceIdentifier.PathArgument> path = new ArrayList<YangInstanceIdentifier.PathArgument>();
        path.addAll(this.getRootPath().getPathArguments());
        Iterator<OperationWithModification> it = this.stack.descendingIterator();
        it.next();
        while (it.hasNext()) {
            path.add(it.next().getModification().getIdentifier());
        }
        throw new SchemaValidationFailedException(String.format("Child %s is not present in schema tree.", path));
    }

    public void enter(@Nonnull YangInstanceIdentifier.PathArgument child) {
        this.stack.push(this.resolveChildModification(child));
    }

    public void enter(@Nonnull Iterable<YangInstanceIdentifier.PathArgument> path) {
        int depth = 0;
        for (YangInstanceIdentifier.PathArgument child : path) {
            try {
                this.stack.push(this.resolveChildModification(child));
            }
            catch (Exception e) {
                for (int i = 0; i < depth; ++i) {
                    this.stack.pop();
                }
                throw new IllegalArgumentException(e);
            }
            ++depth;
        }
    }

    public void exit(int depth) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((depth < this.stack.size() ? 1 : 0) != 0);
        for (int i = 0; i < depth; ++i) {
            this.stack.pop();
        }
    }

    public Optional<NormalizedNode<?, ?>> readNode(@Nonnull YangInstanceIdentifier.PathArgument child) {
        return this.stack.peek().read(child, ((InMemoryDataTreeModification)this.getParent()).getVersion());
    }

    public void delete(YangInstanceIdentifier.PathArgument child) {
        this.ensureNotClosed();
        this.resolveChildModification(child).delete();
    }

    public void merge(YangInstanceIdentifier.PathArgument child, NormalizedNode<?, ?> data) {
        this.ensureNotClosed();
        InMemoryDataTreeModification.checkIdentifierReferencesData(child, data);
        this.resolveChildModification(child).merge(data, ((InMemoryDataTreeModification)this.getParent()).getVersion());
    }

    public void write(YangInstanceIdentifier.PathArgument child, NormalizedNode<?, ?> data) {
        this.ensureNotClosed();
        InMemoryDataTreeModification.checkIdentifierReferencesData(child, data);
        this.resolveChildModification(child).write(data);
    }
}

