/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractCursor;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeSnapshot;

final class InMemoryDataTreeSnapshotCursor
extends AbstractCursor<InMemoryDataTreeSnapshot> {
    private final Deque<NormalizedNodeContainer<?, ?, ?>> stack = new ArrayDeque();

    InMemoryDataTreeSnapshotCursor(InMemoryDataTreeSnapshot parent, YangInstanceIdentifier rootPath, NormalizedNodeContainer<?, ?, ?> normalizedNode) {
        super(parent, rootPath);
        this.stack.push(normalizedNode);
    }

    public void enter(@Nonnull YangInstanceIdentifier.PathArgument child) {
        Optional maybeChildNode = NormalizedNodes.getDirectChild((NormalizedNode)((NormalizedNode)this.stack.peek()), (YangInstanceIdentifier.PathArgument)child);
        Preconditions.checkArgument((boolean)maybeChildNode.isPresent(), (String)"Child %s not found", (Object)child);
        NormalizedNode childNode = (NormalizedNode)maybeChildNode.get();
        Preconditions.checkArgument((boolean)(childNode instanceof NormalizedNodeContainer), (String)"Child %s is not a container", (Object)child);
        this.stack.push((NormalizedNodeContainer)childNode);
    }

    public void enter(@Nonnull Iterable<YangInstanceIdentifier.PathArgument> path) {
        Optional maybeChildNode = NormalizedNodes.findNode((NormalizedNode)((NormalizedNode)this.stack.peek()), path);
        Preconditions.checkArgument((boolean)maybeChildNode.isPresent(), (String)"Child %s not found", path);
        NormalizedNode childNode = (NormalizedNode)maybeChildNode.get();
        Preconditions.checkArgument((boolean)(childNode instanceof NormalizedNodeContainer), (String)"Child %s is not a container", path);
        int depth = 0;
        for (YangInstanceIdentifier.PathArgument arg : path) {
            try {
                this.enter(arg);
            }
            catch (Exception e) {
                for (int i = 0; i < depth; ++i) {
                    this.stack.pop();
                }
                throw new IllegalArgumentException(e);
            }
            ++depth;
        }
    }

    public void exit(int depth) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((depth < this.stack.size() ? 1 : 0) != 0);
        for (int i = 0; i < depth; ++i) {
            this.stack.pop();
        }
    }

    public Optional<NormalizedNode<?, ?>> readNode(@Nonnull YangInstanceIdentifier.PathArgument child) {
        return NormalizedNodes.findNode((NormalizedNode)((NormalizedNode)this.stack.peek()), (YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{child});
    }
}

