/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractDataNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.MandatoryLeafEnforcer;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

final class ListEntryModificationStrategy
extends AbstractDataNodeContainerModificationStrategy<ListSchemaNode> {
    private final MandatoryLeafEnforcer enforcer;

    ListEntryModificationStrategy(ListSchemaNode schema, DataTreeConfiguration treeConfig) {
        super(schema, MapEntryNode.class, treeConfig);
        this.enforcer = MandatoryLeafEnforcer.forContainer((DataNodeContainer)schema, treeConfig);
    }

    @Override
    void verifyStructure(NormalizedNode<?, ?> writtenValue, boolean verifyChildren) {
        super.verifyStructure(writtenValue, verifyChildren);
        if (verifyChildren) {
            this.enforcer.enforceOnData(writtenValue);
        }
    }

    @Override
    protected TreeNode applyMerge(ModifiedNode modification, TreeNode currentMeta, Version version) {
        TreeNode ret = super.applyMerge(modification, currentMeta, version);
        this.enforcer.enforceOnTreeNode(ret);
        return ret;
    }

    @Override
    protected TreeNode applyWrite(ModifiedNode modification, Optional<TreeNode> currentMeta, Version version) {
        TreeNode ret = super.applyWrite(modification, currentMeta, version);
        this.enforcer.enforceOnTreeNode(ret);
        return ret;
    }

    @Override
    protected TreeNode applyTouch(ModifiedNode modification, TreeNode currentMeta, Version version) {
        TreeNode ret = super.applyTouch(modification, currentMeta, version);
        this.enforcer.enforceOnTreeNode(ret);
        return ret;
    }

    @Override
    protected DataContainerNodeBuilder createBuilder(NormalizedNode<?, ?> original) {
        Preconditions.checkArgument((boolean)(original instanceof MapEntryNode));
        return ImmutableMapEntryNodeBuilder.create((MapEntryNode)original);
    }

    @Override
    protected NormalizedNode<?, ?> createEmptyValue(NormalizedNode<?, ?> original) {
        Preconditions.checkArgument((boolean)(original instanceof MapEntryNode));
        return ImmutableMapEntryNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((MapEntryNode)original).getIdentifier()).build();
    }
}

