/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.RequiredElementCountException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ChildTrackingPolicy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationPath;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.NodeModification;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraint;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraintAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MinMaxElementsValidation
extends SchemaAwareApplyOperation {
    private static final Logger LOG = LoggerFactory.getLogger(MinMaxElementsValidation.class);
    private final SchemaAwareApplyOperation delegate;
    private final int minElements;
    private final int maxElements;

    private MinMaxElementsValidation(SchemaAwareApplyOperation delegate, Integer minElements, Integer maxElements) {
        this.delegate = (SchemaAwareApplyOperation)Preconditions.checkNotNull((Object)delegate);
        this.minElements = minElements != null ? minElements : 0;
        this.maxElements = maxElements != null ? maxElements : Integer.MAX_VALUE;
    }

    static SchemaAwareApplyOperation from(SchemaAwareApplyOperation delegate, DataSchemaNode schema) {
        if (!(schema instanceof ElementCountConstraintAware)) {
            return delegate;
        }
        Optional optConstraint = ((ElementCountConstraintAware)schema).getElementCountConstraint();
        if (!optConstraint.isPresent()) {
            return delegate;
        }
        ElementCountConstraint constraint = (ElementCountConstraint)optConstraint.get();
        return new MinMaxElementsValidation(delegate, constraint.getMinElements(), constraint.getMaxElements());
    }

    private void validateMinMaxElements(ModificationPath path, YangInstanceIdentifier.PathArgument id, NormalizedNode<?, ?> data) throws DataValidationFailedException {
        int children = MinMaxElementsValidation.numOfChildrenFromValue(data);
        if (this.minElements > children) {
            throw new RequiredElementCountException(path.toInstanceIdentifier(), this.minElements, this.maxElements, children, "%s does not have enough elements (%s), needs at least %s", new Object[]{id, children, this.minElements});
        }
        if (this.maxElements < children) {
            throw new RequiredElementCountException(path.toInstanceIdentifier(), this.minElements, this.maxElements, children, "%s has too many elements (%s), can have at most %s", new Object[]{id, children, this.maxElements});
        }
    }

    private void checkMinMaxElements(ModificationPath path, NodeModification nodeMod, Optional<TreeNode> current, Version version) throws DataValidationFailedException {
        if (!(nodeMod instanceof ModifiedNode)) {
            LOG.debug("Could not validate {}, does not implement expected class {}", (Object)nodeMod, ModifiedNode.class);
            return;
        }
        ModifiedNode modification = (ModifiedNode)nodeMod;
        Optional<TreeNode> maybeApplied = this.delegate.apply(modification, current, version);
        Verify.verify((boolean)maybeApplied.isPresent());
        TreeNode applied = maybeApplied.get();
        this.validateMinMaxElements(path, modification.getIdentifier(), applied.getData());
        modification.setValidatedNode(this, current, applied);
    }

    private static int numOfChildrenFromValue(NormalizedNode<?, ?> value) {
        if (value instanceof NormalizedNodeContainer) {
            return ((NormalizedNodeContainer)value).getValue().size();
        }
        if (value instanceof UnkeyedListNode) {
            return ((UnkeyedListNode)value).getSize();
        }
        throw new IllegalArgumentException(String.format("Unexpected type '%s', expected types are NormalizedNodeContainer and UnkeyedListNode", value.getClass()));
    }

    @Override
    protected void checkTouchApplicable(ModificationPath path, NodeModification modification, Optional<TreeNode> current, Version version) throws DataValidationFailedException {
        this.delegate.checkTouchApplicable(path, modification, current, version);
        this.checkMinMaxElements(path, modification, current, version);
    }

    @Override
    protected void checkMergeApplicable(ModificationPath path, NodeModification modification, Optional<TreeNode> current, Version version) throws DataValidationFailedException {
        this.delegate.checkMergeApplicable(path, modification, current, version);
        this.checkMinMaxElements(path, modification, current, version);
    }

    @Override
    protected void checkWriteApplicable(ModificationPath path, NodeModification modification, Optional<TreeNode> current, Version version) throws DataValidationFailedException {
        this.delegate.checkWriteApplicable(path, modification, current, version);
        this.checkMinMaxElements(path, modification, current, version);
    }

    @Override
    public Optional<ModificationApplyOperation> getChild(YangInstanceIdentifier.PathArgument child) {
        return this.delegate.getChild(child);
    }

    @Override
    protected void verifyStructure(NormalizedNode<?, ?> modification, boolean verifyChildren) {
        this.delegate.verifyStructure(modification, verifyChildren);
        if (verifyChildren) {
            int children = MinMaxElementsValidation.numOfChildrenFromValue(modification);
            Preconditions.checkArgument((this.minElements <= children ? 1 : 0) != 0, (String)"Node %s does not have enough elements (%s), needs at least %s", (Object)modification.getIdentifier(), (Object)children, (Object)this.minElements);
            Preconditions.checkArgument((this.maxElements >= children ? 1 : 0) != 0, (String)"Node %s has too many elements (%s), can have at most %s", (Object)modification.getIdentifier(), (Object)children, (Object)this.maxElements);
        }
    }

    @Override
    protected TreeNode applyMerge(ModifiedNode modification, TreeNode currentMeta, Version version) {
        TreeNode validated = modification.getValidatedNode(this, Optional.of(currentMeta));
        if (validated != null) {
            return validated;
        }
        return this.delegate.applyMerge(modification, currentMeta, version);
    }

    @Override
    protected TreeNode applyTouch(ModifiedNode modification, TreeNode currentMeta, Version version) {
        TreeNode validated = modification.getValidatedNode(this, Optional.of(currentMeta));
        if (validated != null) {
            return validated;
        }
        return this.delegate.applyTouch(modification, currentMeta, version);
    }

    @Override
    protected TreeNode applyWrite(ModifiedNode modification, Optional<TreeNode> currentMeta, Version version) {
        TreeNode validated = modification.getValidatedNode(this, currentMeta);
        if (validated != null) {
            return validated;
        }
        return this.delegate.applyWrite(modification, currentMeta, version);
    }

    @Override
    protected ChildTrackingPolicy getChildPolicy() {
        return this.delegate.getChildPolicy();
    }

    @Override
    void mergeIntoModifiedNode(ModifiedNode node, NormalizedNode<?, ?> value, Version version) {
        this.delegate.mergeIntoModifiedNode(node, value, version);
    }

    @Override
    void recursivelyVerifyStructure(NormalizedNode<?, ?> value) {
        this.delegate.recursivelyVerifyStructure(value);
    }
}

