/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.LogicalOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;

final class NoopDataTreeCandidate
extends AbstractDataTreeCandidate {
    private static final DataTreeCandidateNode ROOT = new DataTreeCandidateNode(){

        @Nonnull
        public ModificationType getModificationType() {
            return ModificationType.UNMODIFIED;
        }

        @Nonnull
        public Collection<DataTreeCandidateNode> getChildNodes() {
            return Collections.emptyList();
        }

        @Nonnull
        public YangInstanceIdentifier.PathArgument getIdentifier() {
            throw new IllegalStateException("Attempted to read identifier of the no-operation change");
        }

        @Nonnull
        public Optional<NormalizedNode<?, ?>> getDataAfter() {
            return Optional.empty();
        }

        @Nonnull
        public Optional<NormalizedNode<?, ?>> getDataBefore() {
            return Optional.empty();
        }

        public DataTreeCandidateNode getModifiedChild(YangInstanceIdentifier.PathArgument identifier) {
            return null;
        }
    };
    private final TreeNode afterRoot;

    protected NoopDataTreeCandidate(YangInstanceIdentifier rootPath, ModifiedNode modificationRoot, TreeNode afterRoot) {
        super(rootPath);
        Preconditions.checkArgument((modificationRoot.getOperation() == LogicalOperation.NONE ? 1 : 0) != 0);
        this.afterRoot = (TreeNode)Preconditions.checkNotNull((Object)afterRoot);
    }

    public DataTreeCandidateNode getRootNode() {
        return ROOT;
    }

    @Override
    @Nonnull
    protected TreeNode getTipRoot() {
        return this.afterRoot;
    }
}

