/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.MandatoryLeafEnforcer;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;

final class PresenceContainerModificationStrategy
extends ContainerModificationStrategy {
    private final MandatoryLeafEnforcer enforcer;

    PresenceContainerModificationStrategy(ContainerSchemaNode schemaNode, DataTreeConfiguration treeConfig) {
        super(schemaNode, treeConfig);
        this.enforcer = MandatoryLeafEnforcer.forContainer((DataNodeContainer)schemaNode, treeConfig);
    }

    @Override
    void verifyStructure(NormalizedNode<?, ?> writtenValue, boolean verifyChildren) {
        super.verifyStructure(writtenValue, verifyChildren);
        if (verifyChildren) {
            this.enforcer.enforceOnData(writtenValue);
        }
    }

    @Override
    protected TreeNode applyMerge(ModifiedNode modification, TreeNode currentMeta, Version version) {
        TreeNode ret = super.applyMerge(modification, currentMeta, version);
        this.enforcer.enforceOnTreeNode(ret);
        return ret;
    }

    @Override
    protected TreeNode applyWrite(ModifiedNode modification, Optional<TreeNode> currentMeta, Version version) {
        TreeNode ret = super.applyWrite(modification, currentMeta, version);
        this.enforcer.enforceOnTreeNode(ret);
        return ret;
    }

    @Override
    protected TreeNode applyTouch(ModifiedNode modification, TreeNode currentMeta, Version version) {
        TreeNode ret = super.applyTouch(modification, currentMeta, version);
        this.enforcer.enforceOnTreeNode(ret);
        return ret;
    }
}

