/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractDataTreeCandidateNode;

final class RecursiveReplaceCandidateNode
extends AbstractDataTreeCandidateNode {
    private final NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> oldData;

    RecursiveReplaceCandidateNode(NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> oldData, NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> newData) {
        super(newData);
        this.oldData = Objects.requireNonNull(oldData);
    }

    @Nonnull
    public ModificationType getModificationType() {
        return ModificationType.WRITE;
    }

    @Nonnull
    public Optional<NormalizedNode<?, ?>> getDataAfter() {
        return super.dataOptional();
    }

    @Nonnull
    public Optional<NormalizedNode<?, ?>> getDataBefore() {
        return Optional.of(this.oldData);
    }

    public DataTreeCandidateNode getModifiedChild(YangInstanceIdentifier.PathArgument identifier) {
        return RecursiveReplaceCandidateNode.deltaChild(this.oldData, this.getData(), identifier);
    }

    @Nonnull
    public Collection<DataTreeCandidateNode> getChildNodes() {
        return RecursiveReplaceCandidateNode.deltaChildren(this.oldData, this.getData());
    }
}

