/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNodeFactory;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ChildTrackingPolicy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.LogicalOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationPath;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.NodeModification;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;

final class StructuralContainerModificationStrategy
extends ModificationApplyOperation {
    private static final Version FAKE_VERSION = Version.initial();
    private final ContainerModificationStrategy delegate;

    StructuralContainerModificationStrategy(ContainerSchemaNode schemaNode, DataTreeConfiguration treeConfig) {
        this.delegate = new ContainerModificationStrategy(schemaNode, treeConfig);
    }

    private Optional<TreeNode> fakeMeta(Version version) {
        ContainerNode container = ImmutableNodes.containerNode(((ContainerSchemaNode)this.delegate.getSchema()).getQName());
        return Optional.of(TreeNodeFactory.createTreeNode((NormalizedNode)container, (Version)version));
    }

    @Override
    Optional<TreeNode> apply(ModifiedNode modification, Optional<TreeNode> storeMeta, Version version) {
        Optional<TreeNode> ret;
        if (modification.getOperation() == LogicalOperation.TOUCH && !storeMeta.isPresent()) {
            ret = this.delegate.apply(modification, this.fakeMeta(version), version);
            if (!ret.isPresent()) {
                modification.resolveModificationType(ModificationType.UNMODIFIED);
                return ret;
            }
            if (modification.getModificationType() == ModificationType.SUBTREE_MODIFIED) {
                modification.resolveModificationType(ModificationType.APPEARED);
            }
        } else {
            ret = this.delegate.apply(modification, storeMeta, version);
            if (!ret.isPresent()) {
                return ret;
            }
        }
        if (((NormalizedNodeContainer)ret.get().getData()).getValue().isEmpty()) {
            modification.resolveModificationType(ModificationType.DISAPPEARED);
            return Optional.empty();
        }
        return ret;
    }

    @Override
    void checkApplicable(ModificationPath path, NodeModification modification, Optional<TreeNode> current, Version version) throws DataValidationFailedException {
        if (modification.getOperation() == LogicalOperation.TOUCH && !current.isPresent()) {
            this.delegate.checkApplicable(path, modification, this.fakeMeta(FAKE_VERSION), version);
        } else {
            this.delegate.checkApplicable(path, modification, current, version);
        }
    }

    @Override
    void verifyStructure(NormalizedNode<?, ?> modification, boolean verifyChildren) {
        this.delegate.verifyStructure(modification, verifyChildren);
    }

    @Override
    void recursivelyVerifyStructure(NormalizedNode<?, ?> value) {
        this.delegate.recursivelyVerifyStructure(value);
    }

    @Override
    ChildTrackingPolicy getChildPolicy() {
        return this.delegate.getChildPolicy();
    }

    @Override
    void mergeIntoModifiedNode(ModifiedNode modification, NormalizedNode<?, ?> value, Version version) {
        this.delegate.mergeIntoModifiedNode(modification, value, version);
    }

    @Override
    public Optional<ModificationApplyOperation> getChild(YangInstanceIdentifier.PathArgument child) {
        return this.delegate.getChild(child);
    }
}

