/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafSetNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.LeafSetEntryModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;

final class UnorderedLeafSetModificationStrategy
extends AbstractNodeContainerModificationStrategy {
    private final Optional<ModificationApplyOperation> entryStrategy;

    UnorderedLeafSetModificationStrategy(LeafListSchemaNode schema, DataTreeConfiguration treeConfig) {
        super(LeafSetNode.class, treeConfig);
        this.entryStrategy = Optional.of(new LeafSetEntryModificationStrategy(schema));
    }

    @Override
    protected NormalizedNodeContainerBuilder createBuilder(NormalizedNode<?, ?> original) {
        Preconditions.checkArgument((boolean)(original instanceof LeafSetNode));
        return ImmutableLeafSetNodeBuilder.create((LeafSetNode)original);
    }

    @Override
    protected NormalizedNode<?, ?> createEmptyValue(NormalizedNode<?, ?> original) {
        Preconditions.checkArgument((boolean)(original instanceof LeafSetNode));
        return ImmutableLeafSetNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)((LeafSetNode)original).getIdentifier()).build();
    }

    @Override
    public Optional<ModificationApplyOperation> getChild(YangInstanceIdentifier.PathArgument identifier) {
        return identifier instanceof YangInstanceIdentifier.NodeWithValue ? this.entryStrategy : Optional.empty();
    }
}

