/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.codec.DecimalCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;

@Beta
public final class DecimalStringCodec
extends TypeDefinitionAwareCodec<BigDecimal, DecimalTypeDefinition>
implements DecimalCodec<String> {
    private DecimalStringCodec(Optional<DecimalTypeDefinition> typeDef) {
        super(typeDef, BigDecimal.class);
    }

    public static DecimalStringCodec from(DecimalTypeDefinition type) {
        return new DecimalStringCodec(Optional.of(type));
    }

    @Override
    public String serialize(BigDecimal data) {
        return Objects.toString(data, "");
    }

    @Override
    public BigDecimal deserialize(String stringRepresentation) {
        Preconditions.checkArgument((stringRepresentation != null ? 1 : 0) != 0, (Object)"Input cannot be null");
        return new BigDecimal(stringRepresentation);
    }
}

