/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.impl.codec.AbstractIntegerStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BinaryStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BitsStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BooleanStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.DataStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.DecimalStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.EmptyStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.EnumStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.StringStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.UnionStringCodec;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;

public abstract class TypeDefinitionAwareCodec<J, T extends TypeDefinition<T>>
implements DataStringCodec<J> {
    private final Class<J> inputClass;
    private final T typeDefinition;

    protected TypeDefinitionAwareCodec(Optional<T> typeDefinition, Class<J> outputClass) {
        this.typeDefinition = typeDefinition.orElse(null);
        this.inputClass = Objects.requireNonNull(outputClass);
    }

    @Override
    public Class<J> getInputClass() {
        return this.inputClass;
    }

    public Optional<T> getTypeDefinition() {
        return Optional.ofNullable(this.typeDefinition);
    }

    public static TypeDefinitionAwareCodec<Object, ?> from(TypeDefinition<?> typeDefinition) {
        return TypeDefinitionAwareCodec.fromType(typeDefinition);
    }

    public static TypeDefinitionAwareCodec<?, ?> fromType(TypeDefinition<?> typeDefinition) {
        TypeDefinitionAwareCodec codec = typeDefinition instanceof BinaryTypeDefinition ? BinaryStringCodec.from((BinaryTypeDefinition)typeDefinition) : (typeDefinition instanceof BitsTypeDefinition ? BitsStringCodec.from((BitsTypeDefinition)typeDefinition) : (typeDefinition instanceof BooleanTypeDefinition ? BooleanStringCodec.from((BooleanTypeDefinition)typeDefinition) : (typeDefinition instanceof DecimalTypeDefinition ? DecimalStringCodec.from((DecimalTypeDefinition)typeDefinition) : (typeDefinition instanceof EmptyTypeDefinition ? EmptyStringCodec.INSTANCE : (typeDefinition instanceof EnumTypeDefinition ? EnumStringCodec.from((EnumTypeDefinition)typeDefinition) : (typeDefinition instanceof Int8TypeDefinition ? AbstractIntegerStringCodec.from((Int8TypeDefinition)typeDefinition) : (typeDefinition instanceof Int16TypeDefinition ? AbstractIntegerStringCodec.from((Int16TypeDefinition)typeDefinition) : (typeDefinition instanceof Int32TypeDefinition ? AbstractIntegerStringCodec.from((Int32TypeDefinition)typeDefinition) : (typeDefinition instanceof Int64TypeDefinition ? AbstractIntegerStringCodec.from((Int64TypeDefinition)typeDefinition) : (typeDefinition instanceof StringTypeDefinition ? StringStringCodec.from((StringTypeDefinition)typeDefinition) : (typeDefinition instanceof UnionTypeDefinition ? UnionStringCodec.from((UnionTypeDefinition)typeDefinition) : (typeDefinition instanceof Uint8TypeDefinition ? AbstractIntegerStringCodec.from((Uint8TypeDefinition)typeDefinition) : (typeDefinition instanceof Uint16TypeDefinition ? AbstractIntegerStringCodec.from((Uint16TypeDefinition)typeDefinition) : (typeDefinition instanceof Uint32TypeDefinition ? AbstractIntegerStringCodec.from((Uint32TypeDefinition)typeDefinition) : (typeDefinition instanceof Uint64TypeDefinition ? AbstractIntegerStringCodec.from((Uint64TypeDefinition)typeDefinition) : null)))))))))))))));
        return codec;
    }
}

