/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.leafref;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefPath;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefPathParser;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefPathParserBaseListener;
import org.opendaylight.yangtools.yang.data.impl.leafref.QNamePredicateBuilder;
import org.opendaylight.yangtools.yang.data.impl.leafref.QNameWithPredicateBuilder;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;

final class LeafRefPathParserListenerImpl
extends LeafRefPathParserBaseListener {
    private final List<QNameWithPredicateBuilder> leafRefPathQnameList = new ArrayList<QNameWithPredicateBuilder>();
    private final SchemaContext schemaContext;
    private final Module module;
    private final Module leafrefModule;
    private final SchemaNode node;
    private ParsingState currentParsingState = ParsingState.LEAF_REF_PATH;
    private List<QNameWithPredicateBuilder> predicatePathKeyQnameList;
    private QNameWithPredicateBuilder currentLeafRefPathQName;
    private QNamePredicateBuilder currentPredicate;
    private QNameModule currentQnameModule;
    private String currentQNameLocalName;
    private LeafRefPath leafRefPath;
    private boolean relativePath = false;

    LeafRefPathParserListenerImpl(SchemaContext schemaContext, Module leafrefModule, SchemaNode currentNode) {
        this.schemaContext = schemaContext;
        this.module = (Module)schemaContext.findModule(currentNode.getQName().getModule()).get();
        this.leafrefModule = leafrefModule;
        this.node = currentNode;
    }

    @Override
    public void enterPath_predicate(LeafRefPathParser.Path_predicateContext ctx) {
        this.currentParsingState = ParsingState.PATH_PREDICATE;
        this.currentPredicate = new QNamePredicateBuilder();
    }

    @Override
    public void exitPath_predicate(LeafRefPathParser.Path_predicateContext ctx) {
        this.currentLeafRefPathQName.addQNamePredicate(this.currentPredicate.build());
        this.currentPredicate = null;
        this.currentParsingState = ParsingState.LEAF_REF_PATH;
    }

    @Override
    public void enterRel_path_keyexpr(LeafRefPathParser.Rel_path_keyexprContext ctx) {
        this.currentParsingState = ParsingState.PATH_KEY_EXPR;
        List<TerminalNode> dots = ctx.DOTS();
        this.predicatePathKeyQnameList = new ArrayList<QNameWithPredicateBuilder>(dots.size());
        for (int i = 0; i < dots.size(); ++i) {
            this.predicatePathKeyQnameList.add(QNameWithPredicateBuilder.UP_PARENT_BUILDER);
        }
    }

    @Override
    public void exitRel_path_keyexpr(LeafRefPathParser.Rel_path_keyexprContext ctx) {
        LeafRefPath pathKeyExpression = LeafRefPath.create(Lists.transform(this.predicatePathKeyQnameList, QNameWithPredicateBuilder::build), false);
        this.currentPredicate.setPathKeyExpression(pathKeyExpression);
        this.currentParsingState = ParsingState.PREDICATE_PATH_EQUALITY_EXPR;
    }

    @Override
    public void enterRelative_path(LeafRefPathParser.Relative_pathContext ctx) {
        this.relativePath = true;
        List<TerminalNode> dots = ctx.DOTS();
        for (int i = 0; i < dots.size(); ++i) {
            this.leafRefPathQnameList.add(QNameWithPredicateBuilder.UP_PARENT_BUILDER);
        }
    }

    @Override
    public void enterPath_equality_expr(LeafRefPathParser.Path_equality_exprContext ctx) {
        this.currentParsingState = ParsingState.PREDICATE_PATH_EQUALITY_EXPR;
    }

    @Override
    public void exitPath_equality_expr(LeafRefPathParser.Path_equality_exprContext ctx) {
        this.currentParsingState = ParsingState.PATH_PREDICATE;
    }

    @Override
    public void enterPrefix(LeafRefPathParser.PrefixContext ctx) {
        String prefix = ctx.getText();
        if (!this.leafrefModule.getPrefix().equals(prefix)) {
            Optional<QNameModule> qnameModuleOpt = this.getQNameModuleForImportPrefix(this.leafrefModule, prefix);
            Preconditions.checkArgument((boolean)qnameModuleOpt.isPresent(), (String)"No module import for prefix: %s in module: %s", (Object)prefix, (Object)this.leafrefModule.getName());
            this.currentQnameModule = qnameModuleOpt.get();
        } else {
            this.currentQnameModule = this.leafrefModule.getQNameModule();
        }
    }

    @Override
    public void exitPath_arg(LeafRefPathParser.Path_argContext ctx) {
        this.leafRefPath = LeafRefPath.create(Lists.transform(this.leafRefPathQnameList, QNameWithPredicateBuilder::build), !this.relativePath);
    }

    @Override
    public void enterIdentifier(LeafRefPathParser.IdentifierContext ctx) {
        this.currentQNameLocalName = ctx.getText();
    }

    @Override
    public void exitNode_identifier(LeafRefPathParser.Node_identifierContext ctx) {
        if (this.currentQnameModule == null) {
            this.currentQnameModule = this.relativePath ? this.module.getQNameModule() : this.leafrefModule.getQNameModule();
        }
        if (this.currentParsingState == ParsingState.PREDICATE_PATH_EQUALITY_EXPR) {
            this.currentPredicate.setIdentifier(QName.create((QNameModule)this.currentQnameModule, (String)this.currentQNameLocalName));
        } else {
            QNameWithPredicateBuilder qnameBuilder = new QNameWithPredicateBuilder(this.currentQnameModule, this.currentQNameLocalName);
            if (this.currentParsingState == ParsingState.PATH_KEY_EXPR) {
                this.predicatePathKeyQnameList.add(qnameBuilder);
            } else if (this.currentParsingState == ParsingState.LEAF_REF_PATH) {
                this.currentLeafRefPathQName = qnameBuilder;
                this.leafRefPathQnameList.add(qnameBuilder);
            }
        }
        this.currentQnameModule = null;
        this.currentQNameLocalName = null;
    }

    public LeafRefPath getLeafRefPath() {
        return this.leafRefPath;
    }

    private Optional<QNameModule> getQNameModuleForImportPrefix(Module targetModule, String prefix) {
        ModuleImport moduleImport = LeafRefPathParserListenerImpl.getModuleImport(targetModule, prefix);
        if (moduleImport == null) {
            return Optional.empty();
        }
        String moduleName = moduleImport.getModuleName();
        Optional revision = moduleImport.getRevision();
        return this.schemaContext.findModule(moduleName, revision).map(Module::getQNameModule);
    }

    private static ModuleImport getModuleImport(Module targetModule, String prefix) {
        return targetModule.getImports().stream().filter(imp -> prefix.equals(imp.getPrefix())).findFirst().orElse(null);
    }

    private static enum ParsingState {
        LEAF_REF_PATH,
        PATH_PREDICATE,
        PREDICATE_PATH_EQUALITY_EXPR,
        PATH_KEY_EXPR;

    }
}

