/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc7952.data.api.NormalizedMetadata;
import org.opendaylight.yangtools.rfc7952.data.api.NormalizedMetadataStreamWriter;
import org.opendaylight.yangtools.rfc7952.data.util.ImmutableNormalizedMetadata;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriterExtension;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeMetadataResult;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeBuilder;

@Beta
public class ImmutableMetadataNormalizedNodeStreamWriter
extends ImmutableNormalizedNodeStreamWriter
implements NormalizedMetadataStreamWriter {
    private final Deque<ImmutableNormalizedMetadata.Builder> builders = new ArrayDeque<ImmutableNormalizedMetadata.Builder>();
    private final NormalizedNodeMetadataResult result;

    protected ImmutableMetadataNormalizedNodeStreamWriter(State state) {
        super(state.getDataBuilder());
        this.builders.push(state.getMetaBuilder());
        this.result = null;
    }

    protected ImmutableMetadataNormalizedNodeStreamWriter(NormalizedNodeMetadataResult result) {
        super(result);
        this.result = Objects.requireNonNull(result);
    }

    public final ClassToInstanceMap<NormalizedNodeStreamWriterExtension> getExtensions() {
        return ImmutableClassToInstanceMap.of(NormalizedMetadataStreamWriter.class, (Object)this);
    }

    public final void metadata(ImmutableMap<QName, Object> metadata) throws IOException {
        ImmutableNormalizedMetadata.Builder current = this.builders.peek();
        Preconditions.checkState((current != null ? 1 : 0) != 0, (Object)"Attempted to emit metadata when no metadata is open");
        current.withAnnotations(metadata);
    }

    protected final @NonNull State popState() {
        return new State(this.popBuilder(), this.builders.pop());
    }

    @Override
    final void enter(YangInstanceIdentifier.PathArgument identifier, NormalizedNodeBuilder next) {
        super.enter(identifier, next);
        this.builders.push(ImmutableNormalizedMetadata.builder().withIdentifier(identifier));
    }

    @Override
    public final void endNode() {
        super.endNode();
        ImmutableNormalizedMetadata metadata = this.builders.pop().build();
        ImmutableNormalizedMetadata.Builder current = this.builders.peek();
        if (current != null) {
            if (!metadata.getAnnotations().isEmpty() || !metadata.getChildren().isEmpty()) {
                current.withChild(metadata);
            }
        } else {
            this.result.setResult((NormalizedMetadata)metadata);
        }
    }

    public static final class State {
        final ImmutableNormalizedMetadata.Builder metaBuilder;
        final NormalizedNodeBuilder dataBuilder;

        State(NormalizedNodeBuilder dataBuilder, ImmutableNormalizedMetadata.Builder metadataBuilder) {
            this.dataBuilder = Objects.requireNonNull(dataBuilder);
            this.metaBuilder = Objects.requireNonNull(metadataBuilder);
        }

        public NormalizedNodeBuilder getDataBuilder() {
            return this.dataBuilder;
        }

        public ImmutableNormalizedMetadata.Builder getMetaBuilder() {
            return this.metaBuilder;
        }
    }
}

