/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.odlext.model.api.YangModeledAnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableMetadataNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.InterningLeafNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.InterningLeafSetNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeMetadataResult;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResultBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableAnyXmlNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableAugmentationNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableChoiceNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafSetEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafSetNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableOrderedLeafSetNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableOrderedMapNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableUnkeyedListEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableUnkeyedListNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableYangModeledAnyXmlNodeBuilder;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

public class ImmutableNormalizedNodeStreamWriter
implements NormalizedNodeStreamWriter {
    private final Deque<NormalizedNodeBuilder> builders = new ArrayDeque<NormalizedNodeBuilder>();
    private DataSchemaNode nextSchema;

    protected ImmutableNormalizedNodeStreamWriter(NormalizedNodeBuilder topLevelBuilder) {
        this.builders.push(topLevelBuilder);
    }

    protected ImmutableNormalizedNodeStreamWriter(NormalizedNodeResult result) {
        this(new NormalizedNodeResultBuilder(result));
    }

    public static @NonNull NormalizedNodeStreamWriter from(NormalizedNodeContainerBuilder<?, ?, ?, ?> builder) {
        return new ImmutableNormalizedNodeStreamWriter(builder);
    }

    public static NormalizedNodeStreamWriter from(NormalizedNodeResult result) {
        return result instanceof NormalizedNodeMetadataResult ? ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeMetadataResult)result) : new ImmutableNormalizedNodeStreamWriter(result);
    }

    public static NormalizedNodeStreamWriter from(NormalizedNodeMetadataResult result) {
        return new ImmutableMetadataNormalizedNodeStreamWriter(result);
    }

    public void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, InterningLeafNodeBuilder.forSchema(this.nextSchema));
        this.nextSchema = null;
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, -1 == childSizeHint ? InterningLeafSetNodeBuilder.create(this.nextSchema) : InterningLeafSetNodeBuilder.create(this.nextSchema, childSizeHint));
    }

    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) {
        NormalizedNodeBuilder current = this.current();
        Preconditions.checkArgument((current instanceof ImmutableOrderedLeafSetNodeBuilder || current instanceof ImmutableLeafSetNodeBuilder ? 1 : 0) != 0, (String)"LeafSetEntryNode is not valid for parent %s", (Object)current);
        this.enter((YangInstanceIdentifier.PathArgument)name, ImmutableLeafSetEntryNodeBuilder.create());
        this.nextSchema = null;
    }

    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, Builders.orderedLeafSetBuilder());
    }

    public void startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, ImmutableAnyXmlNodeBuilder.create());
        this.nextSchema = null;
    }

    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, -1 == childSizeHint ? ImmutableContainerNodeBuilder.create() : ImmutableContainerNodeBuilder.create(childSizeHint));
    }

    public void startYangModeledAnyXmlNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        Preconditions.checkArgument((boolean)(this.nextSchema instanceof YangModeledAnyXmlSchemaNode), (Object)"Schema of this node should be instance of YangModeledAnyXmlSchemaNode");
        YangModeledAnyXmlSchemaNode anyxmlSchema = (YangModeledAnyXmlSchemaNode)this.nextSchema;
        this.enter((YangInstanceIdentifier.PathArgument)name, -1 == childSizeHint ? ImmutableYangModeledAnyXmlNodeBuilder.create(anyxmlSchema) : ImmutableYangModeledAnyXmlNodeBuilder.create(anyxmlSchema, childSizeHint));
    }

    public void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, -1 == childSizeHint ? ImmutableUnkeyedListNodeBuilder.create() : ImmutableUnkeyedListNodeBuilder.create(childSizeHint));
    }

    public void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        Preconditions.checkArgument((this.current() instanceof NormalizedNodeResultBuilder || this.current() instanceof ImmutableUnkeyedListNodeBuilder ? 1 : 0) != 0);
        this.enter((YangInstanceIdentifier.PathArgument)name, -1 == childSizeHint ? ImmutableUnkeyedListEntryNodeBuilder.create() : ImmutableUnkeyedListEntryNodeBuilder.create(childSizeHint));
    }

    public void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, -1 == childSizeHint ? ImmutableMapNodeBuilder.create() : ImmutableMapNodeBuilder.create(childSizeHint));
    }

    public void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) {
        if (!(this.current() instanceof NormalizedNodeResultBuilder)) {
            Preconditions.checkArgument((this.current() instanceof ImmutableMapNodeBuilder || this.current() instanceof ImmutableOrderedMapNodeBuilder ? 1 : 0) != 0);
        }
        this.enter((YangInstanceIdentifier.PathArgument)identifier, -1 == childSizeHint ? ImmutableMapEntryNodeBuilder.create() : ImmutableMapEntryNodeBuilder.create(childSizeHint));
    }

    public void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, -1 == childSizeHint ? ImmutableOrderedMapNodeBuilder.create() : ImmutableOrderedMapNodeBuilder.create(childSizeHint));
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.checkDataNodeContainer();
        this.enter((YangInstanceIdentifier.PathArgument)name, -1 == childSizeHint ? ImmutableChoiceNodeBuilder.create() : ImmutableChoiceNodeBuilder.create(childSizeHint));
    }

    public void startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier identifier) {
        this.checkDataNodeContainer();
        Preconditions.checkArgument((!(this.current() instanceof ImmutableAugmentationNodeBuilder) ? 1 : 0) != 0);
        this.enter((YangInstanceIdentifier.PathArgument)identifier, Builders.augmentationBuilder());
    }

    public void flush() {
    }

    public void close() {
    }

    public void nextDataSchemaNode(DataSchemaNode schema) {
        this.nextSchema = Objects.requireNonNull(schema);
    }

    public void scalarValue(Object value) {
        this.currentScalar().withValue(value);
    }

    public void domSourceValue(DOMSource value) {
        this.currentScalar().withValue(value);
    }

    public void endNode() {
        NormalizedNodeBuilder finishedBuilder = this.builders.poll();
        Preconditions.checkState((finishedBuilder != null ? 1 : 0) != 0, (Object)"Node which should be closed does not exists.");
        Object product = finishedBuilder.build();
        this.nextSchema = null;
        this.writeChild((NormalizedNode<?, ?>)product);
    }

    protected final void writeChild(NormalizedNode<?, ?> child) {
        NormalizedNodeContainerBuilder current = this.currentContainer();
        Preconditions.checkState((current != null ? 1 : 0) != 0, (Object)"Reached top level node, which could not be closed in this writer.");
        current.addChild(Objects.requireNonNull(child));
    }

    void enter(YangInstanceIdentifier.PathArgument identifier, NormalizedNodeBuilder next) {
        this.builders.push(next.withNodeIdentifier(identifier));
        this.nextSchema = null;
    }

    protected final NormalizedNodeBuilder popBuilder() {
        return this.builders.pop();
    }

    private void checkDataNodeContainer() {
        NormalizedNodeContainerBuilder current = this.currentContainer();
        if (!(current instanceof NormalizedNodeResultBuilder)) {
            Preconditions.checkArgument((boolean)(current instanceof DataContainerNodeBuilder), (Object)"Invalid nesting of data.");
        }
    }

    private NormalizedNodeBuilder current() {
        return this.builders.peek();
    }

    private NormalizedNodeContainerBuilder currentContainer() {
        NormalizedNodeBuilder current = this.current();
        if (current == null) {
            return null;
        }
        Preconditions.checkState((boolean)(current instanceof NormalizedNodeContainerBuilder), (String)"%s is not a node container", (Object)current);
        return (NormalizedNodeContainerBuilder)current;
    }

    private NormalizedNodeBuilder currentScalar() {
        NormalizedNodeBuilder current = this.current();
        Preconditions.checkState((!(current instanceof NormalizedNodeContainerBuilder) ? 1 : 0) != 0, (String)"Unexpected node container %s", (Object)current);
        return current;
    }
}

